/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.links.TrackbackLink;
import com.atlassian.confluence.spaces.Space;

public abstract class SpaceContentEntityObject
extends ContentEntityObject {
    private Space space;

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        Space originalValue = this.space;
        this.space = space;
        if (originalValue != null && space != null && !originalValue.equals(space)) {
            for (Labelling labelling : this.getLabellings()) {
                labelling.setSpaceKey(space.getKey());
            }
        }
    }

    public void addTrackbackLink(TrackbackLink link) {
        super.addTrackbackLink(link);
    }

    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.setSpace(null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.space != null ? this.space.getKey().hashCode() : 0);
        return result;
    }

    public String getNameForComparison() {
        return this.getSpace().getName();
    }

    public String getSpaceKey() {
        return this.getSpace() == null ? null : this.getSpace().getKey();
    }

    public boolean isIndexable() {
        return this.getSpace() != null && super.isIndexable();
    }

    public boolean isInSpace(Space space) {
        if (this.space == null || space == null) {
            return false;
        }
        return this.space.equals(space);
    }
}

