/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.Date;

public class VersionHistorySummary {
    private final long id;
    private final int version;
    private final String lastModifierName;
    private final Date lastModificationDate;
    private final String versionComment;

    @HtmlSafe
    public static String renderVersionComment(String versionComment) {
        WikiStyleRenderer wikiStyleRenderer = (WikiStyleRenderer)ContainerManager.getComponent((String)"wikiStyleRenderer");
        RenderMode renderMode = RenderMode.SIMPLE_TEXT.and(RenderMode.suppress((long)1L));
        PageContext context = new PageContext();
        context.pushRenderMode(renderMode);
        return wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, versionComment);
    }

    public VersionHistorySummary(long contentId, int version, String lastModifierName, Date lastModifiedDate, String versionComment) {
        this.id = contentId;
        this.version = version;
        this.lastModifierName = lastModifierName;
        this.lastModificationDate = lastModifiedDate;
        this.versionComment = versionComment;
    }

    public VersionHistorySummary(ContentEntityObject entity) {
        this.id = entity.getId();
        this.version = entity.getVersion();
        this.lastModifierName = entity.getLastModifierName();
        this.lastModificationDate = entity.getLastModificationDate();
        this.versionComment = entity.getVersionComment();
    }

    public long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getLastModifierName() {
        return this.lastModifierName;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    @HtmlSafe
    public String getRenderedVersionComment() {
        return VersionHistorySummary.renderVersionComment(this.getVersionComment());
    }

    public boolean isVersionCommentAvailable() {
        return TextUtils.stringSet((String)this.getVersionComment()) && this.getVersionComment().trim().length() > 0;
    }
}

