/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.seraph.cookie.CookieFactory;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.List;

public class RedirectActionHelper {
    private WebInterfaceManager webInterfaceManager;

    public RedirectActionHelper(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public String getRedirectUrlAndUpdateCookies(String cookieName, String webItemLocation, WebInterfaceContext context) throws Exception {
        List availableWebItems = this.webInterfaceManager.getDisplayableItems(webItemLocation, context.toMap());
        if (availableWebItems.isEmpty()) {
            ServletActionContext.getResponse().sendError(404);
            return null;
        }
        WebItemModuleDescriptor redirectTo = this.getItemToRedirectTo(availableWebItems, cookieName);
        GeneralUtil.setCookie(cookieName, redirectTo.getKey());
        return redirectTo.getLink().getRenderedUrl(context.toMap());
    }

    private WebItemModuleDescriptor getItemToRedirectTo(List availableWebItems, String cookieName) {
        String cookieValue = CookieFactory.getCookieHandler().getCookieValue(ServletActionContext.getRequest(), cookieName);
        if (TextUtils.stringSet((String)cookieValue)) {
            for (WebItemModuleDescriptor item : availableWebItems) {
                if (!item.getKey().equals(cookieValue)) continue;
                return item;
            }
        }
        return (WebItemModuleDescriptor)availableWebItems.get(0);
    }
}

