/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.themes.ColorSchemeBean;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ThemeColorsStylesheetAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(ThemeColorsStylesheetAction.class);
    private String completeModuleKey;
    private String stylesheetName;
    private String stylesheetLocation;
    private PluginAccessor pluginAccessor;
    private ColorSchemeBean colorScheme;
    private ColourSchemeManager colourSchemeManager;
    private String spaceKey;

    public String execute() throws Exception {
        ResourceLocation resource = this.getStylesheetResource(this.completeModuleKey, this.stylesheetName);
        if (resource == null) {
            log.warn((Object)("Couldn't find matching stylesheet resource for completeModuleKey: [" + this.completeModuleKey + "], stylesheetName: [" + this.stylesheetName + "]"));
            return "error";
        }
        this.colorScheme = new ColorSchemeBean(this.getActiveColorScheme(this.spaceKey));
        this.stylesheetLocation = this.prependSlashIfMissing(resource.getLocation());
        return "success";
    }

    public boolean isPermitted() {
        return true;
    }

    private ResourceLocation getStylesheetResource(String completeModuleKey, String stylesheetName) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(completeModuleKey);
        if (module == null) {
            return null;
        }
        ResourceLocation location = module.getResourceLocation("download", stylesheetName);
        if (location != null) {
            return location;
        }
        return module.getResourceLocation("stylesheet", stylesheetName);
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setCompleteModuleKey(String completeModuleKey) {
        this.completeModuleKey = completeModuleKey;
    }

    public void setStylesheetName(String stylesheetName) {
        this.stylesheetName = stylesheetName;
    }

    private String prependSlashIfMissing(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("/")) {
            return text;
        }
        return "/" + text;
    }

    public ColorSchemeBean getColorScheme() {
        return this.colorScheme;
    }

    private ColourScheme getActiveColorScheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.colourSchemeManager.getSpaceColourScheme(spaceKey);
        }
        return this.colourSchemeManager.getGlobalColourScheme();
    }

    public String getTopBarColor() {
        return this.colorScheme.getTopBarColor();
    }

    public String getBreadcrumbsTextColour() {
        return this.colorScheme.getBreadcrumbsTextColor();
    }

    public String getSpaceNameColor() {
        return this.colorScheme.getSpaceNameColor();
    }

    public String getHeadingTextColor() {
        return this.colorScheme.getHeadingTextColor();
    }

    public String getLinkColor() {
        return this.colorScheme.getLinkColor();
    }

    public String getBorderColor() {
        return this.colorScheme.getBorderColor();
    }

    public String getNavBackgroundColor() {
        return this.colorScheme.getNavBackgroundColor();
    }

    public String getNavTextColor() {
        return this.colorScheme.getNavTextColor();
    }

    public String getNavSelectedBackgroundColor() {
        return this.colorScheme.getNavSelectedBackgroundColor();
    }

    public String getNavSelectedTextColor() {
        return this.colorScheme.getNavSelectedTextColor();
    }

    public String getTopBarColour() {
        return this.colorScheme.getTopBarColor();
    }

    public String getSpaceNameColour() {
        return this.colorScheme.getTopBarColor();
    }

    public String getHeadingTextColour() {
        return this.colorScheme.getHeadingTextColor();
    }

    public String getLinkColour() {
        return this.colorScheme.getLinkColor();
    }

    public String getBorderColour() {
        return this.colorScheme.getBorderColor();
    }

    public String getNavBackgroundColour() {
        return this.colorScheme.getNavBackgroundColor();
    }

    public String getNavTextColour() {
        return this.colorScheme.getNavTextColor();
    }

    public String getNavSelectedBackgroundColour() {
        return this.colorScheme.getNavSelectedBackgroundColor();
    }

    public String getNavSelectedTextColour() {
        return this.colorScheme.getNavSelectedTextColor();
    }

    public void setColourSchemeManager(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }
}

