/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.core.persistence.hibernate.VersionedHibernateObjectDao;
import com.atlassian.confluence.util.ContentUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.opensymphony.util.TextUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.joda.time.DateMidnight;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class ContentEntityObjectHibernateDao
extends VersionedHibernateObjectDao
implements ContentEntityObjectDao {
    public static final long ONE_DAY = 86400000L;
    static Map typeMapping = new HashMap();

    public Class getPersistentClass() {
        return ContentEntityObject.class;
    }

    public ContentEntityObject getById(long id) {
        return (ContentEntityObject)super.getByClassId(id);
    }

    public List getContentAuthoredByUser(String username) {
        return this.findNamedQueryStringParam("confluence.content_findContentAuthoredByUser", "userName", GeneralUtil.specialToLowerCase(username), false);
    }

    public Iterator getAllCurrentEntities() {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findAllCurrentEntities");
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public Iterator getRecentlyAddedEntities(final String spaceKey, final int maxResults) {
        if (TextUtils.stringSet((String)spaceKey)) {
            return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("confluence.content_findRecentlyAddedBySpace");
                    queryObject.setParameter("spaceKey", (Object)spaceKey.toLowerCase());
                    queryObject.setCacheable(true);
                    if (maxResults > 0) {
                        queryObject.setMaxResults(maxResults);
                    }
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                    return queryObject.list().iterator();
                }
            });
        }
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyAdded");
                queryObject.setCacheable(true);
                if (maxResults > 0) {
                    queryObject.setMaxResults(maxResults);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public Iterator getRecentlyModifiedEntities(final int maxResults) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModified");
                queryObject.setCacheable(true);
                if (maxResults > 0) {
                    queryObject.setMaxResults(maxResults);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public Iterator getRecentlyModifiedEntities(final String spaceKey, final int maxResults) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModifiedBySpace");
                queryObject.setParameter("spaceKey", (Object)spaceKey.toLowerCase());
                queryObject.setCacheable(true);
                if (maxResults > 0) {
                    queryObject.setMaxResults(maxResults);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.list().iterator();
            }
        });
    }

    public Iterator getRecentlyModifiedEntitiesForUser(final String username) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModifiedByUser");
                queryObject.setCacheable(true);
                queryObject.setString("username", username);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public Iterator getRecentlyModifiedEntitiesByType(final ListQuery listQuery, final int firstResult) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List spaceIds = ContentUtils.getEntityObjectsIds(listQuery.getSpaceList());
                List labelIds = ContentUtils.getEntityObjectsIds(listQuery.getLabelList());
                List discriminatorList = ContentEntityObjectHibernateDao.this.convertTypeToDiscriminator(listQuery.getTypeList());
                String versionStatus = ContentEntityObjectHibernateDao.this.getStatusString(listQuery.getStatusList());
                Date date = ContentEntityObjectHibernateDao.this.getTimeSpan(listQuery.getTimeSpan());
                boolean queryLabels = listQuery.getLabelList().size() > 0;
                boolean queryAllVersions = listQuery.getStatusList().contains("all");
                boolean queryComments = listQuery.getTypeList().contains("comment");
                String queryString = "select {content.*} from CONTENT {content} " + (queryComments ? "left join CONTENT parent on content.PAGEID = parent.CONTENTID " : "") + (queryAllVersions ? "left join CONTENT original on content.prevver = original.CONTENTID " : "") + (queryLabels ? ", LABEL, CONTENT_LABEL " : "") + "where " + (queryLabels ? "LABEL.LABELID = CONTENT_LABEL.LABELID and LABEL.LABELID in (:labels) and ( {content}.CONTENTID = CONTENT_LABEL.CONTENTID " + (queryAllVersions ? " or original.CONTENTID = CONTENT_LABEL.CONTENTID" : "") + (queryComments ? " or parent.CONTENTID = CONTENT_LABEL.CONTENTID )" : " )") + "and " : "") + "(( {content}.CONTENTTYPE in (:typeList) " + "and {content}.PREVVER is null " + "and {content}.SPACEID in (:spaceIds) " + (listQuery.getTimeSpan() > 0.0f ? "and {content}.LASTMODDATE > :startDate " : "") + "and {content}.CONTENT_STATUS = 'current' " + versionStatus + ") " + (queryComments ? "or ( parent.SPACEID in (:spaceIds) and parent.CONTENTTYPE in ('PAGE', 'BLOGPOST') and parent.CONTENT_STATUS = 'current' ) " : "") + (queryAllVersions ? "or (original.SPACEID in (:spaceIds) and original.CONTENTTYPE in (:typeList))" : "") + ") order by {content}.LASTMODDATE desc";
                Query query = session.createSQLQuery(queryString, "content", ContentEntityObject.class);
                query.setParameterList("spaceIds", (Collection)spaceIds);
                query.setParameterList("typeList", (Collection)discriminatorList);
                if (queryLabels) {
                    query.setParameterList("labels", (Collection)labelIds);
                }
                query.setFirstResult(firstResult);
                if (listQuery.getTimeSpan() > 0.0f) {
                    query.setParameter("startDate", (Object)new Timestamp(date.getTime()));
                }
                if (listQuery.getMaxResults() > 0) {
                    query.setMaxResults(listQuery.getMaxResults());
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                if (VersionedHibernateObjectDao.log.isDebugEnabled()) {
                    String theQuery = query.getQueryString();
                    VersionedHibernateObjectDao.log.debug((Object)("Performing getRecentlyModifiedEntitiesByType query: " + theQuery + "\n\t" + "typeList: " + discriminatorList + "\n\t" + "spaceList: " + spaceIds + "\n\t" + "date: " + date));
                }
                return query.list().iterator();
            }
        });
    }

    public ContentEntityObject getFirstVersionBefore(final long originalVersionContentId, final int version) {
        return (ContentEntityObject)this.findSingleObject((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findPreviousVersion");
                queryObject.setParameter("originalVersionId", (Object)new Long(originalVersionContentId));
                queryObject.setParameter("version", (Object)new Integer(version));
                queryObject.setCacheable(true);
                queryObject.setMaxResults(1);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.list();
            }
        }));
    }

    public ContentEntityObject getFirstVersionAfter(final long originalVersionContentId, final int version) {
        return (ContentEntityObject)this.findSingleObject((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findNextVersion");
                queryObject.setParameter("originalVersionId", (Object)new Long(originalVersionContentId));
                queryObject.setParameter("version", (Object)new Integer(version));
                queryObject.setCacheable(true);
                queryObject.setMaxResults(1);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.list();
            }
        }));
    }

    public ContentEntityObject getVersion(long originalVersionContentId, int version) {
        return (ContentEntityObject)this.findSingleObject(this.findNamedQueryStringParams("confluence.content_findByVersion", "originalVersionId", new Long(originalVersionContentId), "version", new Integer(version), true));
    }

    public List getEntitiesModifiedSince(Date date) {
        return this.getRecentlyModifiedForChangeDigest(date);
    }

    public List getRecentlyModifiedForChangeDigest(final Date fromDate) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModifiedForChangeDigest");
                queryObject.setTimestamp("fromDate", fromDate);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)ContentEntityObjectHibernateDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    private String getStatusString(List statusList) {
        if (statusList == null || statusList.isEmpty()) {
            return "";
        }
        String statusString = "";
        String versionString = "{content}.VERSION";
        String seperator = "";
        if (statusList.contains("created")) {
            statusString = statusString + versionString + "=1 ";
            seperator = "or ";
        }
        if (statusList.contains("modified")) {
            statusString = statusString + seperator + versionString + ">1 ";
        }
        if (TextUtils.stringSet((String)statusString)) {
            return "and (" + statusString + ")";
        }
        return "";
    }

    private Date getTimeSpan(float timeSpan) {
        long finalTimeSpan = (long)(8.64E7 * (double)timeSpan);
        Date currentDate = new Date();
        long fromDate = currentDate.getTime() - finalTimeSpan;
        DateMidnight midnightDate = new DateMidnight(fromDate);
        return midnightDate.toDate();
    }

    public List getLockedContentBySpace(String spaceKey) {
        return this.findNamedQueryStringParam("confluence.content_findLockedBySpace", "spaceKey", spaceKey.toLowerCase());
    }

    public List getTrashedContent(String spaceKey) {
        return this.findNamedQueryStringParam("confluence.content_findTrashedContent", "spaceKey", spaceKey.toLowerCase());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getObjectType(long id) {
        String string;
        ResultSet rs;
        PreparedStatement s;
        block6: {
            Connection conn = null;
            s = null;
            rs = null;
            conn = SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)true).connection();
            s = conn.prepareStatement("select CONTENTTYPE from CONTENT where CONTENTID = ?");
            s.setLong(1, id);
            rs = s.executeQuery();
            if (!rs.next()) break block6;
            String string2 = rs.getString(1);
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((Statement)s);
            return string2;
        }
        try {
            string = null;
        }
        catch (HibernateException e) {
            try {
                throw new InfrastructureException("Error finding type of content with id " + id, (Throwable)e);
                catch (SQLException e2) {
                    throw new InfrastructureException("Error finding type of content with id " + id, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(s);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)s);
        return string;
    }

    public List getVersionHistorySummary(long originalContentId) {
        return this.findNamedQueryStringParam("confluence.content_findVersionHistory", "originalVersionId", new Long(originalContentId), true);
    }

    public List findPreviousVersions(long originalContentId) {
        return this.findNamedQueryStringParam("confluence.content_findPreviousVersions", "originalVersionId", new Long(originalContentId), true);
    }

    private List convertTypeToDiscriminator(List typeList) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < typeList.size(); ++i) {
            String mapping = (String)typeMapping.get(typeList.get(i));
            if (mapping == null) continue;
            values.add(mapping);
        }
        return values;
    }

    static {
        typeMapping.put("page", "PAGE");
        typeMapping.put("blogpost", "BLOGPOST");
        typeMapping.put("mail", "MAIL");
        typeMapping.put("comment", "COMMENT");
        typeMapping.put("userinfo", "USERINFO");
        typeMapping.put("spacedesc", "SPACEDESCRIPTION");
        typeMapping.put("personalspacedesc", "SPACEDESCRIPTION");
    }
}

