/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.config.util.BootstrapUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.type.StringType;

public class StringClobType
extends StringType {
    private boolean isHsql = true;

    public StringClobType() {
        String dialect = BootstrapUtils.getBootstrapManager().getString("hibernate.dialect");
        if (dialect != null && !"net.sf.hibernate.dialect.HSQLDialect".equals(dialect)) {
            this.isHsql = false;
        }
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        if (this.isHsql) {
            return rs.getString(name);
        }
        Reader reader = rs.getCharacterStream(name);
        if (reader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            char[] charbuf = new char[4096];
            int i = reader.read(charbuf);
            while (i > 0) {
                sb.append(charbuf, 0, i);
                i = reader.read(charbuf);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return sb.toString();
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        if (this.isHsql) {
            st.setString(index, (String)value);
        } else {
            StringReader r = new StringReader((String)value);
            st.setCharacterStream(index, (Reader)r, ((String)value).length());
        }
    }

    public int sqlType() {
        if (this.isHsql) {
            return 12;
        }
        return 2005;
    }

    public boolean hasNiceEquals() {
        return false;
    }
}

