/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.core.persistence.VersionedObjectDao;
import com.atlassian.confluence.core.persistence.confluence.StaleObjectStateException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.hibernate.HibernateObjectDao;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class VersionedHibernateObjectDao
extends HibernateObjectDao
implements VersionedObjectDao {
    public static final Category log = Category.getInstance(VersionedHibernateObjectDao.class);
    protected CacheFactory cacheFactory;

    private String generateFindAllQueryString(String sortField) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (Versioned.class.isAssignableFrom(this.getPersistentClass())) {
            query = query + " WHERE result.originalVersion is null";
        }
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        return query;
    }

    public Iterator findLatestVersionsIterator() {
        return this.getHibernateTemplate().iterate(this.generateFindAllQueryString(null));
    }

    public long findLatestVersionsCount() {
        String originalQueryString = "SELECT COUNT(*) " + this.generateFindAllQueryString(null);
        List resultsList = this.getHibernateTemplate().find(originalQueryString);
        if (resultsList.size() == 0) {
            return 0L;
        }
        Number number = (Number)resultsList.get(0);
        return number.longValue();
    }

    public List findAllSorted(String sortField) {
        final String finalQuery = this.generateFindAllQueryString(sortField);
        List result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(finalQuery);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)VersionedHibernateObjectDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public void save(EntityObject objectToSave, EntityObject previousVersion) {
        this.updateModificationData(objectToSave);
        if (objectToSave instanceof Versioned && previousVersion != null) {
            Versioned previousVersioned = (Versioned)previousVersion;
            Versioned updatedVersioned = (Versioned)objectToSave;
            if (updatedVersioned.getVersion() > previousVersioned.getVersion()) {
                throw new StaleObjectStateException("The version of the object to be saved was more than the previous version!");
            }
            previousVersioned.convertToHistoricalVersion();
            previousVersioned.setOriginalVersion(updatedVersioned);
            this.getHibernateTemplate().saveOrUpdate((Object)previousVersion);
            updatedVersioned.setVersion(updatedVersioned.getVersion() + 1);
        }
        this.getHibernateTemplate().saveOrUpdate((Object)objectToSave);
        if (objectToSave instanceof Versioned && previousVersion != null) {
            this.reIndex(objectToSave);
        } else {
            this.index(objectToSave);
        }
    }

    protected void updateModificationData(EntityObject objectToSave) {
        if (objectToSave instanceof ConfluenceEntityObject) {
            this.updateConfluenceModificationData((ConfluenceEntityObject)objectToSave);
        }
        super.updateModificationData(objectToSave);
    }

    private void updateConfluenceModificationData(ConfluenceEntityObject confluenceEntityObject) {
        try {
            String userName = null;
            if (AuthenticatedUserThreadLocal.getUser() != null) {
                userName = AuthenticatedUserThreadLocal.getUser().getName();
            }
            confluenceEntityObject.setLastModifierName(userName);
            if (!confluenceEntityObject.isPersistent()) {
                confluenceEntityObject.setCreatorName(userName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can not fetch the current user!", (Throwable)e);
        }
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }
}

