/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.service;

import com.atlassian.confluence.core.service.DefaultServiceCommandValidator;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceCommand
implements ServiceCommand {
    private ServiceCommandState state = ServiceCommandState.access$000();
    private final ServiceCommandValidator validator = new DefaultServiceCommandValidator();

    @Override
    public final boolean isValid() {
        this.state = this.state.validate(this);
        return this.state.isValid();
    }

    @Override
    public Collection<ValidationError> getValidationErrors() {
        return this.validator.getValidationErrors();
    }

    @Override
    public final boolean isAuthorized() {
        this.state = this.state.authorize(this);
        return this.state.isAuthorized();
    }

    @Override
    public final void execute() {
        this.state = this.state.execute(this);
    }

    private String getCurrentUsername() {
        return this.getCurrentUser() == null ? null : this.getCurrentUser().getName();
    }

    protected final User getCurrentUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    protected abstract void validateInternal(ServiceCommandValidator var1);

    protected abstract boolean isAuthorizedInternal();

    protected abstract void executeInternal();

    private static abstract class ServiceCommandState {
        private static final ServiceCommandState COMPLETE = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                throw new IllegalStateException("Command already executed");
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                throw new IllegalStateException("Command already executed");
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                throw new IllegalStateException("Command already executed");
            }

            boolean isValid() {
                throw new IllegalStateException("Command already executed");
            }

            boolean isAuthorized() {
                throw new IllegalStateException("Command already executed");
            }
        };
        private static final ServiceCommandState VALID = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                command.executeInternal();
                return COMPLETE;
            }

            boolean isValid() {
                return true;
            }

            boolean isAuthorized() {
                return true;
            }
        };
        private static final ServiceCommandState NOT_VALID = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                throw new NotValidException();
            }

            boolean isValid() {
                return false;
            }

            boolean isAuthorized() {
                return true;
            }
        };
        private static final ServiceCommandState AUTHORIZED = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                command.validateInternal(command.validator);
                return command.getValidationErrors().isEmpty() ? VALID : NOT_VALID;
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                command.state = this.validate(command);
                return command.state.execute(command);
            }

            boolean isValid() {
                throw new IllegalStateException("Command is not yet validated");
            }

            boolean isAuthorized() {
                return true;
            }
        };
        private static final ServiceCommandState NOT_AUTHORIZED = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                throw new NotAuthorizedException(command.getCurrentUsername());
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                return this;
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                throw new NotAuthorizedException(command.getCurrentUsername());
            }

            boolean isValid() {
                throw new IllegalStateException("Command is not yet validated");
            }

            boolean isAuthorized() {
                return false;
            }
        };
        private static final ServiceCommandState NEW = new ServiceCommandState(){

            ServiceCommandState validate(AbstractServiceCommand command) {
                command.state = this.authorize(command);
                return command.state.validate(command);
            }

            ServiceCommandState authorize(AbstractServiceCommand command) {
                return command.isAuthorizedInternal() ? AUTHORIZED : NOT_AUTHORIZED;
            }

            ServiceCommandState execute(AbstractServiceCommand command) {
                command.state = this.authorize(command);
                command.state = command.state.validate(command);
                return command.state.execute(command);
            }

            boolean isValid() {
                throw new IllegalStateException("Command is not yet validated");
            }

            boolean isAuthorized() {
                throw new IllegalStateException("Command is not yet authorized");
            }
        };

        private ServiceCommandState() {
        }

        abstract ServiceCommandState validate(AbstractServiceCommand var1);

        abstract ServiceCommandState authorize(AbstractServiceCommand var1);

        abstract ServiceCommandState execute(AbstractServiceCommand var1);

        abstract boolean isValid();

        abstract boolean isAuthorized();

        static /* synthetic */ ServiceCommandState access$000() {
            return NEW;
        }
    }
}

