/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.service;

import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.Collection;

public class RunAsUserCommand
implements ServiceCommand {
    private final ServiceCommand delegate;
    private final User userToRunAs;

    public RunAsUserCommand(User userToRunAs, ServiceCommand delegate) {
        this.userToRunAs = userToRunAs;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        User oldUser = AuthenticatedUserThreadLocal.getUser();
        try {
            AuthenticatedUserThreadLocal.setUser(this.userToRunAs);
            boolean bl = this.delegate.isValid();
            return bl;
        }
        finally {
            AuthenticatedUserThreadLocal.setUser(oldUser);
        }
    }

    public Collection getValidationErrors() {
        return this.delegate.getValidationErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthorized() {
        User oldUser = AuthenticatedUserThreadLocal.getUser();
        try {
            AuthenticatedUserThreadLocal.setUser(this.userToRunAs);
            boolean bl = this.delegate.isAuthorized();
            return bl;
        }
        finally {
            AuthenticatedUserThreadLocal.setUser(oldUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        User oldUser = AuthenticatedUserThreadLocal.getUser();
        try {
            AuthenticatedUserThreadLocal.setUser(this.userToRunAs);
            this.delegate.execute();
        }
        finally {
            AuthenticatedUserThreadLocal.setUser(oldUser);
        }
    }
}

