/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dashboard.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class HomepageAction
extends ConfluenceActionSupport {
    private String siteHomePageSpaceKey;
    private SpaceManager spaceManager;

    public String execute() throws Exception {
        if (this.getRemoteUser() == null) {
            return this.getSiteHomepageResult();
        }
        String userHomePage = this.userAccessor.getPropertySet(this.getRemoteUser()).getString("confluence.user.site.homepage");
        if (userHomePage != null) {
            userHomePage = userHomePage.trim();
        }
        if (!TextUtils.stringSet((String)userHomePage)) {
            return this.getSiteHomepageResult();
        }
        if ("dashboard".equals(userHomePage)) {
            return "success";
        }
        if ("profile".equals(userHomePage)) {
            this.siteHomePageSpaceKey = "~" + this.getRemoteUser().getName();
            return "homepage";
        }
        if ("siteHomepage".equals(userHomePage)) {
            return this.getSiteHomepageResult();
        }
        this.siteHomePageSpaceKey = userHomePage;
        if (this.isSpaceHomePageAccessibleByUser()) {
            return "homepage";
        }
        return super.execute();
    }

    private String getSiteHomepageResult() {
        this.siteHomePageSpaceKey = this.settingsManager.getGlobalSettings().getSiteHomePage();
        if (this.siteHomePageSpaceKey != null) {
            this.siteHomePageSpaceKey = this.siteHomePageSpaceKey.trim();
        }
        if (TextUtils.stringSet((String)this.siteHomePageSpaceKey) && this.isSpaceHomePageAccessibleByUser()) {
            return "homepage";
        }
        return "success";
    }

    public String getSiteHomePageSpaceKey() {
        return this.siteHomePageSpaceKey;
    }

    private boolean isSpaceHomePageAccessibleByUser() {
        if (this.siteHomePageSpaceKey.startsWith("~")) {
            return true;
        }
        Space space = this.spaceManager.getSpace(this.siteHomePageSpaceKey);
        if (space != null) {
            List<String> permissionTypes = super.getPermissionTypes();
            permissionTypes.add("VIEWSPACE");
            return this.spacePermissionManager.hasPermission(permissionTypes, space, this.getRemoteUser());
        }
        return false;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

