/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.events.content.page;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.types.Updated;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class PageMoveEvent
extends PageEvent
implements Updated {
    private User user;
    private Space oldSpace;
    private Page oldParentPage;
    private Integer oldPosition;
    private boolean childrenMoved;

    public PageMoveEvent(Object src, Page movedPage, Space oldSpace, Page oldParentPage, Integer oldPosition, User user) {
        super(src, movedPage);
        this.oldSpace = oldSpace;
        this.oldParentPage = oldParentPage;
        if (oldSpace == null) {
            oldSpace = oldParentPage.getSpace();
        }
        this.oldPosition = oldPosition;
        this.user = user;
        this.childrenMoved = movedPage.hasChildren();
    }

    public PageMoveEvent(Object src, Page movedPage, Page oldParentPage, Space oldSpace, User user, boolean moveChildren) {
        super(src, movedPage);
        this.oldParentPage = oldParentPage;
        this.oldSpace = oldSpace;
        this.user = user;
        this.childrenMoved = moveChildren && movedPage.hasChildren();
    }

    public Space getOldSpace() {
        return this.oldSpace;
    }

    public Page getOldParentPage() {
        return this.oldParentPage;
    }

    public Integer getOldPosition() {
        return this.oldPosition;
    }

    public User getUser() {
        return this.user;
    }

    public Page getNewParentpage() {
        return this.getPage().getParent();
    }

    public boolean hasMovedChildren() {
        return this.childrenMoved || this.getOldSpace().equals(this.getPage().getSpace());
    }

    public static class PageReorder {
        private Page movedPage;
        private Integer oldPosition;

        public PageReorder(Page movedPage, Space oldSpace, Page oldParent, Integer oldPosition) {
            this.movedPage = movedPage;
        }

        public Page getMovedPage() {
            return this.movedPage;
        }

        public Integer getOldPosition() {
            return this.oldPosition;
        }
    }
}

