/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.event.EventUtils;
import com.atlassian.confluence.event.events.admin.ResetHibernateIdRangeEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.hibernate.ResettableTableHiLoGenerator;
import com.atlassian.spring.container.ContainerManager;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.persister.ClassPersister;
import org.apache.log4j.Logger;

public class ResetHiLoAfterImportListener
implements EventListener {
    private Logger log = Logger.getLogger(ResetHiLoAfterImportListener.class);

    public void handleEvent(Event event) {
        Event underlying = EventUtils.extractWrappedEventOrOriginal(event);
        if (!(underlying instanceof ResetHibernateIdRangeEvent)) {
            return;
        }
        this.forceReadOfHiLo();
        this.log.info((Object)"Reset Hi/Lo ids in response to import event");
    }

    private void forceReadOfHiLo() {
        try {
            SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
            Map metadata = sessionFactory.getAllClassMetadata();
            Iterator it = metadata.keySet().iterator();
            while (it.hasNext()) {
                ClassPersister persister = ((SessionFactoryImplementor)sessionFactory).getPersister((Class)it.next());
                IdentifierGenerator idGen = persister.getIdentifierGenerator();
                if (!(idGen instanceof ResettableTableHiLoGenerator)) continue;
                ((ResettableTableHiLoGenerator)idGen).reset();
            }
        }
        catch (HibernateException e) {
            throw new RuntimeException("Unable to reset HiLo identifiers due to", e);
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ResetHibernateIdRangeEvent.class, ClusterEventWrapper.class};
    }
}

