/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.util.List;
import org.apache.log4j.Logger;

public class ThumbnailRemovingListener
implements EventListener {
    private static Logger log = Logger.getLogger(ThumbnailRemovingListener.class);
    private ThumbnailManager thumbnailManager;

    public void handleEvent(Event event) {
        if (!AttachmentEvent.class.isAssignableFrom(event.getClass())) {
            throw new IllegalArgumentException("Found attachment event " + event.getClass() + " that does not subclass " + AttachmentEvent.class.getName());
        }
        List attachments = ((AttachmentEvent)event).getAttachments();
        for (Attachment attachment : attachments) {
            boolean success = this.thumbnailManager.removeThumbnail(attachment);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Thumbnail for attachment: " + attachment.getFileName() + (success ? " successfully removed." : " was not found or could not be removed.")));
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{AttachmentUpdateEvent.class, AttachmentRemoveEvent.class};
    }

    public void setThumbnailManager(ThumbnailManager thumbnailManager) {
        this.thumbnailManager = thumbnailManager;
    }
}

