/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.event.events.admin.ImportFinishedEvent;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.AncestorTableBuilder;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.opensymphony.util.TextUtils;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;

public class UpdateAncestorTableAfterImportListener
implements EventListener {
    public static final Category log = Category.getInstance(UpdateAncestorTableAfterImportListener.class);
    private Class[] HANDLED_EVENTS = new Class[]{ImportFinishedEvent.class};
    private SessionFactory sessionFactory;
    private SpaceManager spaceManager;

    /*
     * Enabled aggressive block sorting
     */
    public void handleEvent(Event event) {
        ImportFinishedEvent importFinishedEvent = (ImportFinishedEvent)event;
        DefaultImportContext importContext = (DefaultImportContext)importFinishedEvent.getImportContext();
        String spaceKeyOfSpaceImport = importContext.getSpaceKeyOfSpaceImport();
        AncestorTableBuilder builder = new AncestorTableBuilder();
        if (!TextUtils.stringSet((String)spaceKeyOfSpaceImport)) {
            builder.build(this.sessionFactory);
            return;
        }
        Space importedSpace = this.spaceManager.getSpace(spaceKeyOfSpaceImport);
        if (importedSpace != null) {
            builder.buildForSpace(this.sessionFactory, importedSpace);
            return;
        }
        log.error((Object)("Could not load valid space for imported space key: " + spaceKeyOfSpaceImport));
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public Class[] getHandledEventClasses() {
        return this.HANDLED_EVENTS;
    }
}

