/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.queues;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusteredTaskQueue;
import com.atlassian.core.task.DefaultTaskQueue;
import com.atlassian.core.task.TaskQueue;

public class TaskQueueFactory {
    private final ClusterManager clusterManager;

    public TaskQueueFactory(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public TaskQueue getQueue(String name) throws Exception {
        return this.getQueueImplementation(name);
    }

    private TaskQueue getQueueImplementation(String name) {
        if (this.clusterManager.isClustered()) {
            return new ClusteredTaskQueue(name, this.clusterManager);
        }
        return new DefaultTaskQueue();
    }
}

