/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.fixonly.actions;

import com.atlassian.confluence.admin.actions.AbstractUpdateLicenseAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthenticateAndUpdateLicenseAction
extends AbstractUpdateLicenseAction {
    private static final Logger log = Logger.getLogger(AuthenticateAndUpdateLicenseAction.class);
    private String username;
    private String password;
    private UserAccessor userAccessor;

    public void validate() {
        super.validate();
        if (StringUtils.isBlank((String)this.getUsername())) {
            this.addFieldError("username", this.getText("error.username.reqd"));
        }
        if (StringUtils.isBlank((String)this.getPassword())) {
            this.addFieldError("password", this.getText("error.password.reqd"));
        }
    }

    public String doUpdate() throws Exception {
        if (!this.isAuthenticatedAndAuthorized()) {
            this.addActionError(this.getText("authenticate.fail.not.admin"));
            return "error";
        }
        return super.doUpdate();
    }

    private boolean isAuthenticatedAndAuthorized() {
        User user = this.userAccessor.getUser(this.getUsername());
        if (user == null) {
            log.debug((Object)("Could not find user " + this.getUsername() + " during license change authentication."));
            return false;
        }
        if (!this.getUserAccessor().authenticate(user.getName(), this.password)) {
            return false;
        }
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isPermitted() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

