/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultExportContext
implements ExportContext {
    private File exportDirectory;
    private String workingFile;
    private List workingEntities = new ArrayList();
    private List exceptionEntities = new ArrayList();
    private boolean exportComments = true;
    private boolean exportAttachments;
    private boolean exportHierarchy;
    private Set processedIds = new HashSet();
    private ContentTree contentTree;
    private DateFormatter dateFormatter;
    private String scope;
    private String type;
    private boolean exportAll = false;
    private User user;

    public static DefaultExportContext getXmlBackupInstance() {
        DefaultExportContext context = new DefaultExportContext();
        context.setType("TYPE_ALL_DATA");
        context.setScope("all");
        return context;
    }

    public String getWorkingFile() {
        return this.workingFile;
    }

    public void setWorkingFile(String workingFile) {
        this.workingFile = workingFile;
    }

    public void addWorkingEntity(ConfluenceEntityObject entity) {
        if (this.workingEntities == null) {
            this.workingEntities = new ArrayList();
        }
        if (!this.workingEntities.contains(entity)) {
            this.workingEntities.add(entity);
        }
    }

    public void addExceptionEntities(List entities, boolean validate) throws IllegalArgumentException {
        if (validate) {
            for (int i = 0; i < entities.size(); ++i) {
                Object o = entities.get(i);
                if (o instanceof ConfluenceEntityObject) continue;
                throw new IllegalArgumentException("Entities list contains something other than a ConfluenceEntityObject - position [" + i + "], o = " + o);
            }
        }
        if (this.exceptionEntities == null) {
            this.exceptionEntities = new ArrayList();
        }
        this.exceptionEntities.addAll(entities);
    }

    public void addExceptionEntity(ConfluenceEntityObject entity) {
        if (this.exceptionEntities == null) {
            this.exceptionEntities = new ArrayList();
        }
        if (!this.exceptionEntities.contains(entity)) {
            this.exceptionEntities.add(entity);
        }
    }

    public boolean isPageInExport(Page page, PageManager pageManager) {
        if (page == null) {
            return false;
        }
        if (this.isExceptionEntity(page)) {
            return false;
        }
        for (Object node : this.getContentTree().getAllContentNodes()) {
            if (node instanceof ContentNode && page.equals(((ContentNode)node).getPage())) {
                return true;
            }
            if (node instanceof Page && page.equals(node)) {
                return true;
            }
            if (!(node instanceof Space)) continue;
            for (Object pageInSpace : pageManager.getPages((Space)node, true)) {
                if (!page.equals(pageInSpace)) continue;
                return true;
            }
        }
        return false;
    }

    public List getExceptionEntities() {
        return this.exceptionEntities;
    }

    public List getWorkingEntities() {
        return this.workingEntities;
    }

    public Set getProcessedIds() {
        return this.processedIds;
    }

    public String getExportDirectoryPath() {
        return this.exportDirectory.getAbsolutePath();
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public boolean isExceptionEntity(ConfluenceEntityObject entity) {
        return this.exceptionEntities != null && this.exceptionEntities.contains(entity);
    }

    public boolean isExportComments() {
        return this.exportComments;
    }

    public void setExportComments(boolean exportComments) {
        this.exportComments = exportComments;
    }

    public boolean isExportAttachments() {
        return this.exportAttachments;
    }

    public void setExportAttachments(boolean exportAttachments) {
        this.exportAttachments = exportAttachments;
    }

    public boolean isExportHierarchy() {
        return this.exportHierarchy;
    }

    public void setExportHierarchy(boolean exportHierarchy) {
        this.exportHierarchy = exportHierarchy;
    }

    public File getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(File exportDirectory) {
        this.exportDirectory = exportDirectory.getAbsoluteFile();
    }

    public ContentTree getContentTree() {
        return this.contentTree;
    }

    public void setContentTree(ContentTree contentTree) {
        this.contentTree = contentTree;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }
}

