/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport;

import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.Exporter;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.Importer;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TreeBuilder;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultImportExportManager
implements ImportExportManager {
    public static final String EXPORT_ALL_FILE_PREFIX = "export-";
    public static final ArrayList importExportTypes = new ArrayList();
    private ContentPermissionManager contentPermissionManager;
    private BootstrapManager bootstrapManager;
    private PageManager pageManager;

    public void importAs(Object type, ImportContext context) throws ImportExportException {
        if (type == null || !type.equals("TYPE_ALL_DATA") && !type.equals("TYPE_XML") && !type.equals("TYPE_MOINMOIN") && !type.equals("TYPE_SNIPSNAP")) {
            throw new IllegalArgumentException("Type must be TYPE_ALL_DATA or TYPE_XML or TYPE_MOINMOIN or TYPE_SNIPSNAP");
        }
        Importer importer = null;
        ContainerContext containerContext = ContainerManager.getInstance().getContainerContext();
        if (type.equals("TYPE_ALL_DATA")) {
            importer = (Importer)containerContext.getComponent((Object)"backupImporter");
            importer.setContext(context);
        } else if (type.equals("TYPE_SNIPSNAP")) {
            importer = (Importer)containerContext.getComponent((Object)"snipsnapImporter");
            importer.setContext(context);
        } else if (type.equals("TYPE_MOINMOIN")) {
            importer = (Importer)containerContext.getComponent((Object)"moinmoinImporter");
            importer.setContext(context);
        }
        importer.doImport();
    }

    public String exportAs(ExportContext context, ProgressMeter progress) throws ImportExportException {
        String type = context.getType();
        if (type == null || !type.equals("TYPE_HTML") && !type.equals("TYPE_PDF") && !type.equals("TYPE_XML") && !type.equals("TYPE_ALL_DATA")) {
            throw new IllegalArgumentException("Type must be TYPE_HTML, TYPE_PDF, TYPE_XML or TYPE_ALL_DATA!");
        }
        Exporter exporter = null;
        ContainerContext containerContext = ContainerManager.getInstance().getContainerContext();
        if (type.equals("TYPE_HTML")) {
            exporter = (Exporter)containerContext.getComponent((Object)"htmlExporter");
            exporter.setContext(context);
        } else if (type.equals("TYPE_PDF")) {
            exporter = (Exporter)containerContext.getComponent((Object)"pdfExporter");
            exporter.setContext(context);
        } else if (type.equals("TYPE_XML")) {
            exporter = (Exporter)containerContext.getComponent((Object)"xmlExporter");
            exporter.setContext(context);
        } else if (type.equals("TYPE_ALL_DATA")) {
            exporter = (Exporter)containerContext.getComponent((Object)"backupExporter");
            exporter.setContext(context);
        }
        return exporter.doExport(progress);
    }

    public List getImportExportTypeSpecifications() {
        return importExportTypes;
    }

    public ContentTree getContentTree(User user, Space space) {
        TreeBuilder treeBuilder = new TreeBuilder(user, this.contentPermissionManager, this.pageManager);
        return treeBuilder.createPageTree(space);
    }

    public String prepareDownloadPath(String path) throws IOException {
        String homeDir = new File(this.bootstrapManager.getConfluenceHome()).getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        String result = path;
        if (homeDirIndex != -1) {
            result = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        }
        result = "/download/" + result;
        result = result.replaceAll("\\".equals(File.separator) ? "\\\\" : File.separator, "/");
        return result;
    }

    public ContentPermissionManager getContentPermissionManager() {
        return this.contentPermissionManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    static {
        importExportTypes.add("TYPE_ALL_DATA");
        importExportTypes.add("TYPE_XML");
        importExportTypes.add("TYPE_HTML");
        importExportTypes.add("TYPE_PDF");
        importExportTypes.add("TYPE_SNIPSNAP");
        importExportTypes.add("TYPE_MOINMOIN");
        importExportTypes.add("page");
        importExportTypes.add("space");
        importExportTypes.add("all");
    }
}

