/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractBackupRestoreAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(AbstractBackupRestoreAction.class);
    protected ImportExportManager importExportManager;
    protected boolean synchronous = false;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public String getSystemFileSeparator() {
        return File.separator;
    }

    public Collection getFilesInRestoreFolder() {
        List<Object> files = new ArrayList();
        File restoreDirectory = new File(this.getBootstrapManager().getConfluenceHome() + File.separator + "restore");
        if (restoreDirectory != null && restoreDirectory.isDirectory()) {
            files = Arrays.asList(restoreDirectory.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile();
                }
            }));
        } else if (!restoreDirectory.mkdir()) {
            log.error((Object)("Error trying to create restore directory [" + restoreDirectory + "] in confluence home."));
        }
        if (!files.isEmpty()) {
            Collections.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File file1 = (File)o1;
                    File file2 = (File)o2;
                    return new Long(file1.lastModified()).compareTo(new Long(file2.lastModified()));
                }
            });
            Collections.reverse(files);
        }
        return files;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

