/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractBackupRestoreAction;
import com.atlassian.confluence.importexport.actions.ImportLongRunningTask;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.xwork.FileUploadUtils;
import com.opensymphony.util.TextUtils;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractImportAction
extends AbstractBackupRestoreAction {
    private static final Logger log = Logger.getLogger(AbstractImportAction.class);
    public static final String RESTORE_DIR = "restore";
    private String localFileName;
    private boolean buildIndex = false;

    public String execute() throws Exception {
        try {
            if (this.isImportAllowed()) {
                this.doRestore();
            }
        }
        catch (ImportExportException iee) {
            this.addActionError(iee.getMessage());
            log.debug((Object)iee.getMessage(), (Throwable)iee);
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            this.addActionError(unexpectedImportZipFileContents.getMessage());
        }
        if (this.getActionErrors().size() > 0) {
            return "error";
        }
        return "success";
    }

    public LongRunningTask getTask() {
        return LongRunningTaskUtils.retrieveTask();
    }

    protected void doRestore() throws ImportExportException, UnexpectedImportZipFileContents {
        ImportLongRunningTask task = new ImportLongRunningTask();
        task.setType("TYPE_ALL_DATA");
        DefaultImportContext context = this.createImportContext();
        context.setRebuildIndex(this.isBuildIndex());
        task.setContext(context);
        task.setImportExportManager(this.importExportManager);
        if (this.isSynchronous()) {
            task.run();
        } else {
            LongRunningTaskUtils.startTask((LongRunningTask)task);
        }
    }

    protected File getRestoreFileFromUpload() throws ImportExportException {
        try {
            File file = FileUploadUtils.getSingleFile();
            if (file == null) {
                throw new ImportExportException("No files uploaded.");
            }
            return file;
        }
        catch (FileUploadUtils.FileUploadException e) {
            String[] errors = e.getErrors();
            for (int i = 0; i < errors.length; ++i) {
                this.addActionError(e.getErrors()[i]);
            }
            throw new ImportExportException("Error uploading file.");
        }
    }

    protected File getRestoreFileFromFileSystem() throws ImportExportException {
        if (!TextUtils.stringSet((String)this.getLocalFileName())) {
            throw new ImportExportException("No local file specified");
        }
        File restoreDirectory = new File(this.getBootstrapManager().getConfluenceHome() + File.separator + RESTORE_DIR);
        if (restoreDirectory != null && restoreDirectory.isDirectory()) {
            File localRestoreFile = new File(restoreDirectory, this.getLocalFileName());
            if (localRestoreFile != null && localRestoreFile.exists() && localRestoreFile.isFile()) {
                return localRestoreFile;
            }
            throw new ImportExportException(this.getLocalFileName() + " does not exist in your restore directory.");
        }
        throw new ImportExportException("Restore directory doesn't exist. You need to create a directory called 'restore' in your Confluence home folder and then copy your restore file there");
    }

    protected boolean isImportAllowed() throws ImportExportException, UnexpectedImportZipFileContents {
        return true;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public boolean isBuildIndex() {
        return this.buildIndex;
    }

    public void setBuildIndex(boolean buildIndex) {
        this.buildIndex = buildIndex;
    }

    protected abstract DefaultImportContext createImportContext() throws ImportExportException, UnexpectedImportZipFileContents;
}

