/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractBackupRestoreAction;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import com.opensymphony.util.TextUtils;
import java.io.File;

public class BackupAction
extends AbstractBackupRestoreAction {
    private String downloadPath;
    private boolean archiveBackup;
    private boolean backupAttachments;
    private GateKeeper gateKeeper;

    public String doDefault() throws Exception {
        this.backupAttachments = true;
        return super.doDefault();
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public String execute() throws Exception {
        try {
            DefaultExportContext exportContext = DefaultExportContext.getXmlBackupInstance();
            exportContext.setExportAttachments(this.isBackupAttachments());
            String archivePath = this.importExportManager.exportAs(exportContext, new ProgressMeter());
            this.downloadPath = this.prepareDownloadPath(archivePath);
            if (this.archiveBackup) {
                int i = archivePath.lastIndexOf(File.separator);
                String exportFilename = archivePath.substring(i + 1);
                String backupDir = this.getBootstrapManager().getFilePathProperty("daily.backup.dir");
                FileUtils.copyFile((File)new File(archivePath), (File)new File(backupDir + File.separator + exportFilename), (boolean)false);
            }
            this.gateKeeper.addKey(this.downloadPath, this.getRemoteUser());
            return "success";
        }
        catch (ImportExportException e) {
            this.addActionError(GeneralUtil.getStackTrace(e));
            return "error";
        }
    }

    private String prepareDownloadPath(String path) {
        String homeDir = this.getBootstrapManager().getConfluenceHome();
        int homeDirIndex = path.indexOf(homeDir);
        if (homeDirIndex != -1) {
            path = path.substring(homeDirIndex + homeDir.length() + 1);
        }
        return this.getBootstrapManager().getWebAppContextPath() + "/download/" + TextUtils.noNull((String)path).replaceAll("\\\\", "/");
    }

    public boolean isArchiveBackup() {
        return this.archiveBackup;
    }

    public void setArchiveBackup(boolean archiveBackup) {
        this.archiveBackup = archiveBackup;
    }

    public boolean isBackupAttachments() {
        return this.backupAttachments;
    }

    public void setBackupAttachments(boolean backupAttachments) {
        this.backupAttachments = backupAttachments;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

