/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.core.util.PairType;
import com.atlassian.core.util.ProgressMeter;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExportPageAction
extends AbstractPageAwareAction
implements PageAware {
    private ImportExportManager importExportManager;
    private List availableTypes = null;
    private String type;
    private String downloadPath;
    private boolean includeComments;
    private boolean backupAttachments;
    private boolean backupHierarchy;
    private GateKeeper gateKeeper;

    public boolean isPageRequired() {
        return true;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public List getAvailableTypes() {
        if (this.availableTypes == null) {
            this.availableTypes = new ArrayList();
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-html")), (Serializable)((Object)"TYPE_HTML")));
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-pdf")), (Serializable)((Object)"TYPE_PDF")));
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-xml")), (Serializable)((Object)"TYPE_XML")));
        }
        return this.availableTypes;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public boolean isIncludeComments() {
        return this.includeComments;
    }

    public void setIncludeComments(boolean includeComments) {
        this.includeComments = includeComments;
    }

    public String doDefault() throws Exception {
        this.includeComments = true;
        this.backupAttachments = true;
        this.backupHierarchy = true;
        return super.doDefault();
    }

    public String execute() throws Exception {
        DefaultExportContext context = new DefaultExportContext();
        context.setScope("page");
        context.setType(this.type);
        context.addWorkingEntity(this.getPage());
        context.setExportComments(this.includeComments);
        context.setExportAttachments(this.backupAttachments);
        context.setExportHierarchy(this.backupHierarchy);
        context.setUser(this.getRemoteUser());
        ContentTree ctree = new ContentTree();
        ctree.addRootNode(new ContentNode((Page)this.getPage()));
        context.setContentTree(ctree);
        String archivePath = this.importExportManager.exportAs(context, new ProgressMeter());
        this.downloadPath = this.prepareDownloadPath(archivePath);
        if (TextUtils.stringSet((String)this.downloadPath)) {
            this.downloadPath = this.downloadPath.replaceAll("\\\\", "/");
        }
        this.gateKeeper.addKey(this.downloadPath, this.getRemoteUser());
        return "success";
    }

    private String prepareDownloadPath(String path) throws IOException {
        String homeDir = new File(this.getBootstrapManager().getConfluenceHome()).getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        if (homeDirIndex != -1) {
            path = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        }
        return "/download/" + path;
    }

    protected List getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("EXPORTPAGE", permissionTypes);
        if (permissionTypes.contains("EDITSPACE")) {
            permissionTypes.remove("EDITSPACE");
        }
        return permissionTypes;
    }

    public boolean isBackupAttachments() {
        return this.backupAttachments;
    }

    public void setBackupAttachments(boolean backupAttachments) {
        this.backupAttachments = backupAttachments;
    }

    public boolean isBackupHierarchy() {
        return this.backupHierarchy;
    }

    public void setBackupHierarchy(boolean backupHierarchy) {
        this.backupHierarchy = backupHierarchy;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }
}

