/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.List;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ExportSpaceLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private ImportExportManager importExportManager;
    private PermissionManager permissionManager;
    private User remoteUser;
    private GateKeeper gateKeeper;
    private String contextPath;
    private ExportContext exportContext;
    private List contentToBeExported;
    private String downloadPath;
    private String type;
    private String contentOption;
    private Space space;

    public ExportSpaceLongRunningTask(User remoteUser, String contextPath, ExportContext exportContext, List contentToBeExported, GateKeeper gateKeeper, ImportExportManager importExportManager, PermissionManager permissionManager, String type, String contentOption) {
        this.remoteUser = remoteUser;
        this.contextPath = contextPath;
        this.exportContext = exportContext;
        this.contentToBeExported = contentToBeExported;
        this.gateKeeper = gateKeeper;
        this.importExportManager = importExportManager;
        this.permissionManager = permissionManager;
        this.type = type;
        this.contentOption = contentOption;
        this.space = (Space)exportContext.getWorkingEntities().get(0);
    }

    protected void runInternal() {
        TransactionTemplate tt = new TransactionTemplate();
        tt.setTransactionManager((PlatformTransactionManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"transactionManager"));
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                AuthenticatedUserThreadLocal.setUser(ExportSpaceLongRunningTask.this.remoteUser);
                try {
                    DefaultExportContext defaultExportContext = (DefaultExportContext)ExportSpaceLongRunningTask.this.exportContext;
                    if ("TYPE_XML".equals(ExportSpaceLongRunningTask.this.type) && "all".equals(ExportSpaceLongRunningTask.this.contentOption) && ExportSpaceLongRunningTask.this.isSpaceAdminOrConfAdmin()) {
                        defaultExportContext.setExportAll(true);
                    } else if (ExportSpaceLongRunningTask.this.contentToBeExported.size() > 0) {
                        ContentTree contentTree = ExportSpaceLongRunningTask.this.importExportManager.getContentTree(ExportSpaceLongRunningTask.this.remoteUser, ExportSpaceLongRunningTask.this.space);
                        contentTree.filter(ExportSpaceLongRunningTask.this.contentToBeExported);
                        defaultExportContext.setContentTree(contentTree);
                    } else {
                        defaultExportContext.setContentTree(new ContentTree());
                    }
                    String archivePath = ExportSpaceLongRunningTask.this.importExportManager.exportAs(ExportSpaceLongRunningTask.this.exportContext, ExportSpaceLongRunningTask.this.progress);
                    ExportSpaceLongRunningTask.this.downloadPath = ExportSpaceLongRunningTask.this.importExportManager.prepareDownloadPath(archivePath);
                    ExportSpaceLongRunningTask.this.gateKeeper.addKey(ExportSpaceLongRunningTask.this.downloadPath, ExportSpaceLongRunningTask.this.remoteUser);
                    ExportSpaceLongRunningTask.this.progress.setStatus("Export complete. Download <a href=\"" + ExportSpaceLongRunningTask.this.contextPath + ExportSpaceLongRunningTask.this.downloadPath + "\">here</a>.");
                    ExportSpaceLongRunningTask.this.progress.setPercentage(100);
                    ExportSpaceLongRunningTask.this.progress.setCompletedSuccessfully(true);
                }
                catch (Exception e) {
                    AbstractLongRunningTask.log.error((Object)"Error during export", (Throwable)e);
                    ExportSpaceLongRunningTask.this.progress.setStatus("There was an error in the export. Please check your log files. :" + e.getMessage());
                    ExportSpaceLongRunningTask.this.progress.setCompletedSuccessfully(false);
                }
                finally {
                    ServletContextThreadLocal.setRequest(null);
                }
            }
        });
    }

    private boolean isSpaceAdminOrConfAdmin() {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, this.space) || this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public String getName() {
        return "Export Space";
    }

    public String getNameKey() {
        return "export.space.task.name";
    }
}

