/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractImportAction;
import com.atlassian.confluence.importexport.actions.ImportLongRunningTask;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.task.longrunning.LongRunningTask;
import java.util.List;

public class ImportSnipSnapAction
extends AbstractImportAction {
    Long spaceId;
    private SpaceManager spaceManager;

    protected void doRestore() throws ImportExportException {
        DefaultImportContext importContext = this.createImportContext();
        ImportLongRunningTask importer = new ImportLongRunningTask();
        importer.setType("TYPE_SNIPSNAP");
        importer.setContext(importContext);
        LongRunningTaskUtils.startTask((LongRunningTask)importer);
    }

    protected DefaultImportContext createImportContext() throws ImportExportException {
        DefaultImportContext importContext = new DefaultImportContext(this.getRestoreFileFromUpload().getAbsolutePath(), this.getRemoteUser());
        importContext.setDefaultSpace(this.getSpace());
        return importContext;
    }

    public List getSpaces() {
        return this.spaceManager.getSpacesByType(SpaceType.GLOBAL);
    }

    public Space getSpace() {
        return this.spaceManager.getSpace(this.spaceId);
    }

    public Long getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(Long spaceId) {
        this.spaceId = spaceId;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

