/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractFileRestoreAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import java.io.File;

public class RestoreLocalFileAction
extends AbstractFileRestoreAction {
    protected DefaultImportContext createImportContext() throws ImportExportException {
        if (this.getRestoreFileFromFileSystem() == null) {
            throw new ImportExportException("Error loading the file " + this.getLocalFileName());
        }
        DefaultImportContext defaultImportContext = new DefaultImportContext(this.getRestoreFileFromFileSystem().getAbsolutePath(), this.getRemoteUser());
        defaultImportContext.setDeleteWorkingFile(false);
        return defaultImportContext;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    protected File getRestoreFile() throws ImportExportException {
        return this.getRestoreFileFromFileSystem();
    }
}

