/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.RestoreAction;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class RestorePageAction
extends RestoreAction
implements SpaceAdministrative,
Spaced {
    protected SpaceManager spaceManager;
    protected Space space;
    protected String key;
    WikiStyleRenderer wikiStyleRenderer;
    ThemeHelper themeHelper;

    protected boolean isImportAllowed() throws ImportExportException {
        String exportType = null;
        try {
            exportType = ExportUtils.getExportTypeFromExportZip(this.getRestoreFileFromUpload());
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            this.addActionError(unexpectedImportZipFileContents.getMessage());
            return false;
        }
        if (TextUtils.stringSet((String)exportType)) {
            if ("page".equals(exportType)) {
                return true;
            }
            this.addActionError(this.getText("error.can.only.import.backups.of.pages"));
        } else {
            this.addActionError(this.getText("error.export.type.could.not.be.determined"));
        }
        return false;
    }

    public boolean isValidSpaceKey() {
        if (StringUtils.isNotEmpty((String)this.getKey())) {
            for (int i = 0; i < this.getKey().length(); ++i) {
                if (Character.isLetterOrDigit(this.getKey().charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasCreatePermission(this.getRemoteUser(), this.space, Page.class);
    }

    public Space getSpace() {
        if (this.space == null && this.isValidSpaceKey()) {
            this.space = this.spaceManager.getSpace(this.getKey());
        }
        return this.space;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    protected DefaultImportContext createImportContext() throws ImportExportException, UnexpectedImportZipFileContents {
        DefaultImportContext importContext = super.createImportContext();
        importContext.setDefaultSpace(this.getSpace());
        importContext.setIncrementalImport(true);
        importContext.setDeleteWorkingFile(false);
        return importContext;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public WikiStyleRenderer getWikiStyleRenderer() {
        return this.wikiStyleRenderer;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public ThemeHelper getThemeHelper() {
        return this.getHelper();
    }
}

