/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.log4j.Category;

public class SetupRestoreHelper {
    public static final Category log = Category.getInstance(SetupRestoreHelper.class);

    public static void prepareForRestore() {
        SetupRestoreHelper.logoutCurrentUser();
        SetupRestoreHelper.recreateSearchIndex();
    }

    private static void recreateSearchIndex() {
        try {
            LuceneConnection luceneConnection = (LuceneConnection)ContainerManager.getInstance().getContainerContext().getComponent((Object)"luceneConnection");
            luceneConnection.recreateIndexDirectory();
        }
        catch (Exception e) {
            log.error((Object)"Error creating Lucene index directory", (Throwable)e);
        }
    }

    private static void logoutCurrentUser() {
        try {
            SecurityConfigFactory.getInstance().getAuthenticator().logout(ServletActionContext.getRequest(), ServletActionContext.getResponse());
            log.info((Object)"Successfully logged out existing user from the session");
        }
        catch (AuthenticatorException e) {
            log.error((Object)"Error logging out the current logged-in user from the session", (Throwable)e);
        }
    }

    public static void postRestoreSteps() {
        BootstrapUtils.getBootstrapManager().getSetupPersister().progessSetupStep();
        BootstrapUtils.getBootstrapManager().getSetupPersister().progessSetupStep();
    }
}

