/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.Exporter;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ObjectHandleTranslator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.ProgressMeter;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public abstract class AbstractExporterImpl
extends Exporter {
    private static Counter idGenerator = new Counter();

    protected DefaultExportContext getWorkingExportContext() {
        return (DefaultExportContext)this.context;
    }

    protected void ensurePathExists(String path) throws ImportExportException {
        File file = new File(path);
        if (!file.exists() && !file.mkdirs()) {
            throw new ImportExportException("Can not create the temporary directory for export [" + path + "]!");
        }
    }

    public String doExport(ObjectHandleTranslator translator, ProgressMeter progress) throws ImportExportException {
        this.getWorkingExportContext().setExportDirectory(this.getExportDirectory());
        return this.getWorkingExportContext().getExportDirectory().getAbsolutePath();
    }

    private File getExportDirectory() throws ImportExportException {
        File exportDir = GeneralUtil.createTempDirectoryInConfluenceTemp("export").getAbsoluteFile();
        this.ensureDirectoryCreated(exportDir);
        return exportDir;
    }

    protected void ensureDirectoryCreated(File directory) throws ImportExportException {
        if (directory.exists() && directory.isDirectory()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Directory exists not created [" + directory + "]"));
            }
            return;
        }
        if (directory.exists() && directory.isFile()) {
            throw new ImportExportException("Export directory exists but is a file [" + directory + "]");
        }
        if (!directory.mkdirs()) {
            throw new ImportExportException("Couldn't create directory: " + directory.getAbsolutePath());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Directory created [" + directory + "]"));
        }
    }

    protected final String prepareExportFileName(ConfluenceEntityObject entity) {
        Date date = new Date();
        if (entity instanceof Space) {
            Space space = (Space)entity;
            String pattern = "{0}-{1,date,yyyyMMdd}-{2,time,HH_mm_ss}-" + idGenerator.getNext();
            String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
            return MessageFormat.format(pattern, spaceKey, date, date);
        }
        if (entity instanceof Page) {
            Page page = (Page)entity;
            String pattern = "{0}-{1}-{2,date,yyyyMMdd}-{3,time,HH_mm_ss}" + idGenerator.getNext();
            String pageIdString = String.valueOf(page.getId());
            String spaceKey = this.getSpaceKeyForExportFileName(page.getSpace().getKey());
            return MessageFormat.format(pattern, spaceKey, pageIdString, date, date);
        }
        String pattern = "export-{0,date,yyyyMMdd}-{1,time,HH_mm_ss}-" + idGenerator.getNext();
        return MessageFormat.format(pattern, date, date);
    }

    protected String getSpaceKeyForExportFileName(String spaceKey) {
        if (spaceKey.startsWith("~")) {
            spaceKey = spaceKey.substring(1);
        }
        return spaceKey;
    }

    protected void checkHaveSomethingToExport() throws ImportExportException {
        if (this.getWorkingExportContext() == null) {
            throw new ImportExportException("Context is NULL. Nothing to export!");
        }
        List working_entities = this.getWorkingExportContext().getWorkingEntities();
        if (working_entities == null || working_entities.isEmpty()) {
            throw new ImportExportException("Nothing to export!");
        }
    }

    private static final class Counter {
        private long id = 0L;

        private Counter() {
        }

        public synchronized long getNext() {
            return this.id++;
        }
    }
}

