/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.AbstractExporterImpl;
import com.atlassian.confluence.importexport.impl.ExportImageDescriptor;
import com.atlassian.confluence.importexport.impl.ExportPathUtils;
import com.atlassian.confluence.importexport.impl.HtmlImageParser;
import com.atlassian.confluence.importexport.impl.ImageProcessingRule;
import com.atlassian.confluence.importexport.impl.TrivialObjectHandleTranslator;
import com.atlassian.confluence.importexport.impl.WikiExporter;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.TemplateSupport;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractRendererExporterImpl
extends AbstractExporterImpl {
    private static final Logger log = Logger.getLogger(AbstractExporterImpl.class);
    private SubRenderer subRenderer;
    private IconManager iconManager;
    private WikiStyleRenderer wikiStyleRenderer;
    protected ThemeManager themeManager;
    protected GeneralUtil generalUtil = new GeneralUtil();
    protected AttachmentManager attachmentManager;
    private TextUtils textUtil = new TextUtils();
    protected SettingsManager settingsManager;
    protected SpaceManager spaceManager;
    protected PageManager pageManager;
    private DownloadResourceManager downloadResourceManager;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;

    protected abstract String getFullExportPath(String var1, ConfluenceEntityObject var2) throws ImportExportException;

    protected abstract void doExportEntity(ConfluenceEntityObject var1, String var2) throws ImportExportException;

    protected DefaultExportContext getWorkingExportContext() {
        return super.getWorkingExportContext();
    }

    public String doExport(ProgressMeter progress) throws ImportExportException {
        this.checkHaveSomethingToExport();
        String baseExportPath = super.doExport(new TrivialObjectHandleTranslator(), progress);
        for (ConfluenceEntityObject entity : this.getWorkingExportContext().getWorkingEntities()) {
            if (entity instanceof Page) {
                this.exportPage((Page)entity, baseExportPath);
                continue;
            }
            if (entity instanceof Space) {
                this.exportSpace((Space)entity, baseExportPath);
                continue;
            }
            throw new ImportExportException("Data type is not supported to export!");
        }
        return baseExportPath;
    }

    protected void exportSpace(Space space, String baseExportPath) throws ImportExportException {
        String exportPath = this.getFullExportPath(baseExportPath, space);
        this.ensurePathExists(new File(exportPath).getParent());
        log.debug((Object)("trying to export space " + space.getKey()));
        this.doExportEntity(space, exportPath);
    }

    protected void exportPage(Page page, String baseExportPath) throws ImportExportException {
        String exportPath = this.getFullExportPath(baseExportPath, page);
        this.ensurePathExists(new File(exportPath).getParent());
        log.debug((Object)("trying to export page " + page.getTitle() + " in space " + page.getSpace().getKey()));
        this.doExportEntity(page, exportPath);
    }

    protected abstract ImageProcessingRule getImageProcessingRule(String var1);

    protected void exportImages(String html, Writer writer, String exportDir) {
        HtmlImageParser parser = new HtmlImageParser();
        try {
            Set exportImages = parser.parse(html.toCharArray(), writer, this.getImageProcessingRule(exportDir));
            for (ExportImageDescriptor exportImageDescriptor : exportImages) {
                this.exportResource(exportImageDescriptor.getImagePath(), exportDir, exportImageDescriptor.getExportPath());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while parsing the images for the export", (Throwable)e);
        }
    }

    protected void exportResource(String resourceUrl, String exportDir, String exportPath) {
        File destinationFile;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Export from resourceUrl = " + resourceUrl));
            log.debug((Object)("Export to exportPath = " + exportPath));
        }
        if ((destinationFile = new File(exportDir, exportPath)).exists()) {
            return;
        }
        String userName = AuthenticatedUserThreadLocal.getUsername();
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String resourcePath = ExportPathUtils.constructRelativePath(baseUrl, resourceUrl);
        try {
            if (this.downloadResourceManager.matches(resourcePath)) {
                DownloadResourceReader downloadResourceReader = this.downloadResourceManager.getResourceReader(userName, resourcePath, ExportPathUtils.getQueryParameters(resourceUrl));
                if (downloadResourceReader != null) {
                    FileUtils.copyFile((InputStream)downloadResourceReader.getStreamForReading(), (File)destinationFile, (boolean)false);
                }
            } else {
                log.warn((Object)("There is no download resource manager to export the resource: " + resourcePath));
            }
        }
        catch (UnauthorizedDownloadResourceException e) {
            log.error((Object)("User [" + userName + "] is unauthorised to export the resource: " + resourcePath));
        }
        catch (DownloadResourceNotFoundException e) {
            log.error((Object)("Resource not found for export: " + resourcePath));
        }
        catch (IOException e) {
            log.error((Object)("There was an error exporting the resource: " + resourcePath), (Throwable)e);
        }
    }

    protected TemplateSupport createTemplateSupport(String template_extension) {
        TemplateSupport template_support = new TemplateSupport(this.themeManager, template_extension);
        WikiExporter wikiExporter = new WikiExporter();
        wikiExporter.setSubRenderer(this.subRenderer);
        wikiExporter.setIconManager(this.iconManager);
        wikiExporter.setWikiStyleRenderer(this.wikiStyleRenderer);
        wikiExporter.setLinkPrefix(this.getLinkPrefix());
        wikiExporter.setLinkPostfix(this.getLinkPostfix());
        wikiExporter.setLinkToExports(this.getLinkToExports());
        wikiExporter.setExportContext(this.context);
        wikiExporter.setSettingsManager(this.settingsManager);
        template_support.putInContext("generalUtil", this.generalUtil);
        template_support.putInContext("textUtil", this.textUtil);
        template_support.putInContext("rendererBean", wikiExporter);
        template_support.putInContext("exportDate", new Date());
        template_support.putInContext("exportContext", this.context);
        template_support.putInContext("dateFormatter", this.getDateFormatter(this.context.getUser()));
        template_support.putInContext("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        return template_support;
    }

    private DateFormatter getDateFormatter(User user) {
        return this.userAccessor.getConfluenceUserPreferences(user).getDateFormatter(this.formatSettingsManager);
    }

    protected abstract String getLinkPrefix();

    protected abstract String getLinkPostfix();

    protected abstract boolean getLinkToExports();

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public void setDownloadResourceManager(DownloadResourceManager downloadResourceManager) {
        this.downloadResourceManager = downloadResourceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }
}

