/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.quartz.AbstractClusterAwareQuartzJobBean;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BackupJob
extends AbstractClusterAwareQuartzJobBean {
    private static final Category log = Category.getInstance(BackupJob.class);
    private ImportExportManager importExportManager;
    private BootstrapManager bootstrapManager;
    private SettingsManager settingsManager;

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJob(JobExecutionContext jec) throws JobExecutionException {
        String dailyBackupDirectory = this.bootstrapManager.getFilePathProperty("daily.backup.dir");
        if (dailyBackupDirectory == null || dailyBackupDirectory.trim().equals("")) {
            log.warn((Object)"No daily backup directory specified to store the backups. Taking no action!");
            return;
        }
        try {
            Settings globalSettings = this.settingsManager.getGlobalSettings();
            DefaultExportContext exportContext = DefaultExportContext.getXmlBackupInstance();
            exportContext.setExportAttachments(globalSettings.isBackupAttachmentsDaily());
            String exportPath = this.importExportManager.exportAs(exportContext, new ProgressMeter());
            String dailyBackupFilename = globalSettings.getDailyBackupFilePrefix() + new SimpleDateFormat(globalSettings.getDailyBackupDateFormatPattern()).format(new Date()) + ".zip";
            File realDestination = new File(dailyBackupDirectory, dailyBackupFilename);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(exportPath);
                FileUtils.copyFile((InputStream)fis, (File)realDestination, (boolean)true);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while running the scheduled backup", (Throwable)e);
        }
    }
}

