/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import java.util.Iterator;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Fetchable;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Value;

public final class BackupRestoreHibernateUtil {
    public static void prepareConfigurationForBackupOperation(Configuration config) {
        Iterator mappings = config.getClassMappings();
        while (mappings.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)mappings.next();
            persistentClass.setProxyInterface(persistentClass.getMappedClass());
            Iterator propertyIterator = persistentClass.getPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                Value value = property.getValue();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    collection.setLazy(true);
                }
                if (!(value instanceof Fetchable)) continue;
                Fetchable fetchable = (Fetchable)value;
                fetchable.setOuterJoinFetchSetting(-1);
            }
        }
    }
}

