/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.security.DownloadGateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.quartz.AbstractClusterAwareQuartzJobBean;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CleanTempDirectoryJob
extends AbstractClusterAwareQuartzJobBean {
    private BootstrapManager bootstrapManager;
    private DownloadGateKeeper gateKeeper;
    private static final String FILE_AGE_KEY = "deleteFilesOlderThanHours";

    public void executeJob(JobExecutionContext context) throws JobExecutionException {
        File[] files = this.getTemporaryFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!this.shouldBeDeleted(file, context)) continue;
            FileUtils.deleteDir((File)files[i]);
        }
        this.gateKeeper.cleanAllKeys();
    }

    private File[] getTemporaryFiles() {
        File tempDirectory = new File(this.bootstrapManager.getConfluenceHome(), "temp");
        return tempDirectory.listFiles();
    }

    private boolean shouldBeDeleted(File temporaryFile, JobExecutionContext context) {
        String hoursString = (String)context.getMergedJobDataMap().get((Object)FILE_AGE_KEY);
        int hours = 1;
        try {
            hours = Integer.parseInt(hoursString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new Date().getTime() - temporaryFile.lastModified() > (long)hours * 3600000L;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGateKeeper(DownloadGateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }
}

