/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.PageCreateLink;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.Icon;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.SubRenderer;
import com.opensymphony.util.TextUtils;

public class ExportLinkRenderer
implements LinkRenderer {
    private String linkPrefix;
    private String linkPostfix;
    public static final String EXPORT_CONTEXT = "EXPORT_CONTEXT";
    public static final String LINK_PREFIX = "LINK_PREFIX";
    public static final String LINK_POSTFIX = "LINK_POSTFIX";
    private ExportContext exportContext;
    private IconManager iconManager;
    private PageManager pageManager;
    private SubRenderer subRenderer;
    private boolean linkToExports = true;

    public ExportLinkRenderer(SubRenderer subRenderer, String linkPrefix, String linkPostfix, ExportContext exportContext, IconManager iconManager, PageManager pageManager, boolean linkToExports) {
        this.subRenderer = subRenderer;
        this.linkPrefix = linkPrefix;
        this.linkPostfix = linkPostfix;
        this.exportContext = exportContext;
        this.iconManager = iconManager;
        this.pageManager = pageManager;
        this.linkToExports = linkToExports;
    }

    public String renderLink(Link link) {
        return this.renderLink(link, new PageContext());
    }

    public String renderLink(Link link, RenderContext context) {
        if (!(context instanceof PageContext)) {
            return RenderUtils.error((RenderContext)context, (String)"[Unknown context for drawing a link]", null, (boolean)false);
        }
        PageContext pageContext = (PageContext)context;
        StringBuffer buffer = new StringBuffer();
        if (link instanceof UnresolvedLink || link instanceof UnpermittedLink || link instanceof PageCreateLink) {
            buffer.append(link.getLinkBody());
            return buffer.toString();
        }
        buffer.append("<a href=\"");
        buffer.append(this.resolve(link, pageContext));
        buffer.append("\"");
        if (TextUtils.stringSet((String)link.getTitle())) {
            buffer.append(" title=\"").append(link.getTitle()).append("\"");
        }
        buffer.append(">");
        Icon icon = this.iconManager.getLinkDecoration(link.getIconName());
        if (icon.position == -1) {
            icon.toHtml(pageContext.getImagePath());
        }
        if (link.getLinkBody().equals(link.getUrl())) {
            buffer.append(this.subRenderer.render(link.getLinkBody(), context, RenderMode.allow((long)4224L)));
        } else {
            buffer.append(this.subRenderer.render(link.getLinkBody(), context, RenderMode.PHRASES_IMAGES));
        }
        if (icon.position == 1) {
            icon.toHtml(pageContext.getImagePath());
        }
        buffer.append("</a>");
        return buffer.toString();
    }

    private boolean isExportedPage(Link link) {
        if (!(link instanceof PageLink)) {
            return false;
        }
        ContentEntityObject destination = ((PageLink)link).getDestinationContent();
        if (!(destination instanceof Page)) {
            return false;
        }
        return this.exportContext.isPageInExport((Page)destination, this.pageManager);
    }

    private String resolve(Link link, PageContext context) {
        if (link instanceof AttachmentLink) {
            return this.resolve((AttachmentLink)link, context);
        }
        if (link instanceof PageLink) {
            return this.resolve((PageLink)link, context);
        }
        StringBuffer buffer = new StringBuffer();
        if (link.isRelativeUrl()) {
            buffer.append(context.getBaseUrl());
        }
        buffer.append(UrlUtil.escapeSpecialCharacters((String)link.getUrl()));
        return buffer.toString();
    }

    private String resolve(AttachmentLink link, PageContext context) {
        if (!this.linkToExports || !this.isExportedPage((Link)link.getAbstractPageLink())) {
            return this.renderExternalLink(link, context);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.linkPrefix != null) {
            buffer.append(this.linkPrefix);
        } else {
            buffer.append("download/attachments/");
        }
        buffer.append(link.getAbstractPageLink().getDestinationContent().getId());
        buffer.append("/");
        buffer.append(link.getAttachment().getFileName());
        return buffer.toString();
    }

    private String renderExternalLink(BaseLink link, PageContext context) {
        StringBuffer externalLink = new StringBuffer();
        if (link.isRelativeUrl()) {
            externalLink.append(context.getBaseUrl());
        }
        externalLink.append(UrlUtil.escapeSpecialCharacters((String)link.getUrl()));
        return externalLink.toString();
    }

    private String resolve(PageLink link, PageContext context) {
        boolean isOnSamePage;
        if (!this.isExportedPage((Link)link)) {
            return this.renderExternalLink(link, context);
        }
        StringBuffer buffer = new StringBuffer();
        boolean bl = isOnSamePage = context != null && link.isOnSamePage(context);
        if (!isOnSamePage) {
            String pageTitle;
            if (this.linkPrefix != null) {
                buffer.append(this.linkPrefix);
            }
            if (GeneralUtil.isSafeTitleForUrl(pageTitle = link.getDestinationContent().getTitle())) {
                buffer.append(pageTitle);
            } else {
                buffer.append(link.getDestinationContent().getId());
            }
            if (this.linkPostfix != null) {
                buffer.append(this.linkPostfix);
            }
        }
        if (TextUtils.stringSet((String)link.getAnchor(context))) {
            buffer.append("#").append(link.getAnchor(context));
        }
        return buffer.toString();
    }
}

