/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.opensymphony.util.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExportPathUtils {
    private static final Logger log = Logger.getLogger(ExportPathUtils.class);

    static String constructRelativeExportPath(String baseUrl, String imageSource) {
        try {
            URL base = new URL(baseUrl);
            String contextPath = base.getPath();
            URL url = new URL(base, imageSource);
            String relativePath = url.getPath();
            if (TextUtils.stringSet((String)contextPath) && relativePath.startsWith(contextPath)) {
                relativePath = relativePath.substring(contextPath.length());
            }
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            return relativePath;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("invalid path " + imageSource));
            return "images/" + imageSource;
        }
    }

    static String constructRelativePath(String baseUrl, String resourcePath) {
        String newBaseUrl = baseUrl + (baseUrl.endsWith("/") ? "" : "/");
        try {
            URL base = new URL(newBaseUrl);
            String contextPath = base.getPath();
            URL url = new URL(base, resourcePath);
            String relativePath = url.getPath();
            if (TextUtils.stringSet((String)contextPath) && !relativePath.startsWith(contextPath)) {
                if (contextPath.endsWith("/")) {
                    contextPath = contextPath.substring(0, contextPath.length() - 1);
                }
                relativePath = contextPath + relativePath;
            }
            return relativePath;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Invalid path " + resourcePath));
            return resourcePath;
        }
    }

    static Map getQueryParameters(String url) {
        String query;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (url.indexOf("?") != -1 && (query = url.substring(url.indexOf("?") + 1)) != null) {
            String[] queryList = query.split("&");
            for (int i = 0; i < queryList.length; ++i) {
                String queryParameter = queryList[i];
                String[] queryParameters = queryParameter.split("=");
                if (queryParameters != null && queryParameters.length == 2) {
                    parameters.put(queryParameters[0], queryParameters[1]);
                    continue;
                }
                parameters.put(queryParameter, null);
            }
        }
        return parameters;
    }
}

