/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.zip.FileUnzipper;
import com.atlassian.core.util.FileUtils;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportUtils {
    public static final String PROP_BUILD_NUMBER = "buildNumber";
    public static final String PROP_EXPORT_TYPE = "exportType";
    public static final String PROP_BACKUP_ATTACHMENTS = "backupAttachments";
    private static Category log = Category.getInstance(ExportUtils.class);

    public static String getExportTypeFromExportZip(File exportZip) throws ImportExportException, UnexpectedImportZipFileContents {
        return ExportUtils.getExportTypeFromExportZip(exportZip, false);
    }

    public static String getExportTypeFromExportZip(File exportZip, boolean cleanup) throws ImportExportException, UnexpectedImportZipFileContents {
        Properties exportDescriptorProperties = ExportUtils.getExportDescriptor(exportZip, cleanup);
        if (exportDescriptorProperties != null) {
            return exportDescriptorProperties.getProperty(PROP_EXPORT_TYPE);
        }
        return null;
    }

    public static Properties getExportDescriptor(File exportZip, boolean cleanup) throws ImportExportException, UnexpectedImportZipFileContents {
        try {
            File extractedDirectory = GeneralUtil.createTempDirectoryInConfluenceTemp("import");
            FileUnzipper fileUnzipper = new FileUnzipper(exportZip, extractedDirectory);
            if (fileUnzipper.unzipFileInArchive("exportDescriptor.properties") == null) {
                throw new UnexpectedImportZipFileContents("exportDescriptor.properties", exportZip);
            }
            File exportDescriptorFile = new File(extractedDirectory, "exportDescriptor.properties");
            Properties result = GeneralUtil.getPropertiesFromFile(exportDescriptorFile);
            if (cleanup && !FileUtils.deleteDir((File)extractedDirectory)) {
                log.error((Object)("Could not cleanup contents of temp/import within conf.home. Directory was [" + extractedDirectory + "]"));
            }
            return result;
        }
        catch (IOException e) {
            log.error((Object)("Error determining export type from export zip: " + exportZip.getPath()), (Throwable)e);
            throw new ImportExportException("Error unzipping file (This may be due to a large zip file): " + e.getMessage(), e);
        }
    }

    public static boolean isSpaceImport(File importFile) throws ImportExportException, UnexpectedImportZipFileContents {
        if (importFile == null) {
            throw new IllegalArgumentException("Must specify a valid path to import file.");
        }
        String exportType = ExportUtils.getExportTypeFromExportZip(importFile, true);
        return "space".equals(exportType);
    }

    public static String getSpaceKeyFromExportZip(File exportZip) throws ImportExportException, UnexpectedImportZipFileContents {
        String spaceName = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser parser = saxParserFactory.newSAXParser();
            FileInputStream is = new FileInputStream(ExportUtils.getFileFromZip(exportZip, "entities.xml"));
            SpaceKeyHandler handler = new SpaceKeyHandler();
            try {
                parser.parse((InputStream)is, (DefaultHandler)handler);
            }
            catch (FoundKeySAXException fkse) {
                spaceName = handler.getSpaceKey();
            }
            ((InputStream)is).close();
            String string = spaceName;
            return string;
        }
        catch (ParserConfigurationException e) {
            throw new ImportExportException(e);
        }
        catch (SAXException e) {
            throw new ImportExportException(e);
        }
        catch (FileNotFoundException e) {
            throw new ImportExportException(e);
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        finally {
            ExportUtils.cleanupAfterGetFileFromZip(exportZip);
        }
    }

    private static File getFileFromZip(File exportZip, String name) throws ImportExportException, UnexpectedImportZipFileContents {
        try {
            File extractedDirectory = ExportUtils.getExtractDirectory();
            FileUnzipper fileUnzipper = new FileUnzipper(exportZip, extractedDirectory);
            fileUnzipper.unzipFileInArchive(name);
            File f = new File(extractedDirectory, name);
            if (!f.exists()) {
                throw new UnexpectedImportZipFileContents(name, exportZip);
            }
            return f;
        }
        catch (Exception e) {
            throw new ImportExportException("Error unzipping file: " + e.getMessage(), e);
        }
    }

    private static File getExtractDirectory() {
        return GeneralUtil.createTempDirectoryInConfluenceTemp("import");
    }

    private static void cleanupAfterGetFileFromZip(File exportZip) {
        if (!FileUtils.deleteDir((File)ExportUtils.getExtractDirectory())) {
            log.error((Object)("Could not cleanup contents of temp/import within conf.home. Directory was [" + ExportUtils.getExtractDirectory() + "]"));
        }
    }

    private static class SpaceKeyHandler
    extends DefaultHandler {
        private boolean inSpaceObject = false;
        private boolean inKeyAttribute = false;
        private CharArrayWriter contents = new CharArrayWriter();

        private SpaceKeyHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inKeyAttribute) {
                this.contents.write(ch, start, length);
            }
        }

        public String getSpaceKey() {
            return this.contents.toString();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (qName.equals("object")) {
                String clazz = attributes.getValue("class");
                if (clazz != null && clazz.equals("Space")) {
                    this.inSpaceObject = true;
                }
            } else if (this.inSpaceObject && qName.equals("property") && (name = attributes.getValue("name")) != null && name.equals("key")) {
                this.inKeyAttribute = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inKeyAttribute) {
                throw new FoundKeySAXException();
            }
            if (qName.equals("object")) {
                this.inSpaceObject = false;
            }
            this.inKeyAttribute = false;
        }
    }

    private static class FoundKeySAXException
    extends SAXException {
        public FoundKeySAXException() {
            super("found space key");
        }
    }
}

