/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.AbstractRendererExporterImpl;
import com.atlassian.confluence.importexport.impl.ExportPathUtils;
import com.atlassian.confluence.importexport.impl.HtmlImageProcessingRule;
import com.atlassian.confluence.importexport.impl.ImageProcessingRule;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.TemplateSupport;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HtmlExporter
extends AbstractRendererExporterImpl {
    private static Logger log = Logger.getLogger(HtmlExporter.class);

    protected String getLinkPostfix() {
        return ".html";
    }

    protected boolean getLinkToExports() {
        return true;
    }

    protected String getLinkPrefix() {
        return null;
    }

    public String doExport(ProgressMeter progress) throws ImportExportException {
        String base_export_path = super.doExport(progress);
        ConfluenceEntityObject first_entity = (ConfluenceEntityObject)this.getWorkingExportContext().getWorkingEntities().get(0);
        String archive_path = base_export_path + File.separator + this.prepareExportFileName(first_entity) + ".zip";
        if (this.context.isExportHierarchy() && first_entity instanceof Page) {
            Page indexPage = null;
            try {
                indexPage = (Page)first_entity.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)"Can't clone page?!", (Throwable)e);
                throw new InfrastructureException("Can't clone content entity object: " + indexPage, (Throwable)e);
            }
            indexPage.setTitle("Index");
            indexPage.setChildren(new ArrayList(1));
            indexPage.getChildren().add(first_entity);
            this.exportPage(indexPage, base_export_path);
        }
        try {
            FileUtils.createZipFile((File)new File(base_export_path), (File)new File(archive_path));
            return archive_path;
        }
        catch (Exception e) {
            throw new ImportExportException(e);
        }
    }

    protected void exportPage(Page page, String baseExportPath) throws ImportExportException {
        if (this.context.isExportHierarchy() && page.hasChildren()) {
            List children = page.getChildren();
            for (Page child : children) {
                this.exportPage(child, baseExportPath);
            }
        }
        String exportPath = this.getFullExportPath(baseExportPath, page);
        this.ensurePathExists(new File(exportPath).getParent());
        this.doExportEntity(page, exportPath);
    }

    protected void exportSpace(Space space, String baseExportPath) throws ImportExportException {
        super.exportSpace(space, baseExportPath);
        List contentNodes = this.getWorkingExportContext().getContentTree().getAllContentNodes();
        for (ContentNode contentNode : contentNodes) {
            this.exportPage(contentNode.getPage(), baseExportPath);
        }
    }

    private TemplateSupport prepareExportTemplate(ConfluenceEntityObject entity) {
        TemplateSupport templateSupport = this.createTemplateSupport("htmlexport.vm");
        if (entity instanceof Space) {
            Space space = (Space)entity;
            templateSupport.putInContext("space", space);
            templateSupport.putInContext("contentTree", this.getWorkingExportContext().getContentTree());
        } else if (entity instanceof Page) {
            Page page = (Page)entity;
            templateSupport.putInContext("page", page);
            templateSupport.setExportChildren(this.context.isExportHierarchy());
        }
        return templateSupport;
    }

    protected ImageProcessingRule getImageProcessingRule(String exportDir) {
        return new HtmlImageProcessingRule(this.settingsManager.getGlobalSettings().getBaseUrl());
    }

    protected String getFullExportPath(String base_export_path, ConfluenceEntityObject entity) throws ImportExportException {
        StringBuffer export_path = new StringBuffer(base_export_path);
        export_path.append(File.separator);
        if (entity instanceof Space) {
            Space space = (Space)entity;
            export_path.append(this.getSpaceKeyForExportFileName(space.getKey()));
            export_path.append(File.separator).append("index");
        } else if (entity instanceof Page) {
            Page page = (Page)entity;
            export_path.append(this.getSpaceKeyForExportFileName(page.getSpace().getKey()));
            export_path.append(File.separator);
            if (GeneralUtil.isSafeTitleForUrl(page.getTitle())) {
                export_path.append(page.getTitle());
            } else {
                export_path.append(page.getId());
            }
        } else {
            throw new ImportExportException("Unsupported export type: " + entity.getClass());
        }
        export_path.append(".html");
        return export_path.toString();
    }

    protected void doExportEntity(ConfluenceEntityObject entity, String exportPath) throws ImportExportException {
        Writer writer = null;
        StringWriter stringWriter = new StringWriter();
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(exportPath), "UTF-8"));
            this.prepareExportTemplate(entity).processTemplate(entity, stringWriter);
            String exportDir = new File(exportPath).getParent();
            this.exportImages(stringWriter.toString(), writer, exportDir);
            if (entity instanceof Page) {
                Page page = (Page)entity;
                List attachments = page.getAttachments();
                for (Attachment attachment : attachments) {
                    String imageSource = attachment.getDownloadPath();
                    String exportSource = ExportPathUtils.constructRelativeExportPath(this.settingsManager.getGlobalSettings().getBaseUrl(), imageSource);
                    this.exportResource(imageSource, exportDir, exportSource);
                }
                FileUtils.saveTextFile((String)ConfluenceRenderUtils.renderDefaultStylesheet(), (File)new File(exportDir, "styles/site.css"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred during export.", (Throwable)e);
            log.error((Object)("Entity being exported was: " + entity));
            throw new ImportExportException(e);
        }
        finally {
            try {
                stringWriter.close();
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing the writer!", (Throwable)e);
            }
        }
    }
}

