/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.importexport.impl.ExportImageDescriptor;
import com.atlassian.confluence.importexport.impl.ExportPathUtils;
import com.atlassian.confluence.importexport.impl.ImageProcessingRule;
import com.opensymphony.module.sitemesh.html.BasicRule;
import com.opensymphony.module.sitemesh.html.CustomTag;
import com.opensymphony.module.sitemesh.html.Tag;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class HtmlImageProcessingRule
extends BasicRule
implements ImageProcessingRule {
    private static final Logger log = Logger.getLogger(HtmlImageProcessingRule.class);
    private final Set urls = new HashSet();
    private String baseUrl;

    public HtmlImageProcessingRule(String baseUrl) {
        super(new String[]{"img"});
        this.baseUrl = baseUrl;
    }

    public void process(Tag tag) {
        if (tag.hasAttribute("src", false)) {
            String imageSource = tag.getAttributeValue("src", false);
            if (this.isConfluenceResource(imageSource)) {
                String exportSource = ExportPathUtils.constructRelativeExportPath(this.baseUrl, imageSource);
                ExportImageDescriptor imageDescriptor = new ExportImageDescriptor(imageSource, exportSource);
                CustomTag customTag = new CustomTag(tag);
                customTag.setAttributeValue("src", false, exportSource);
                customTag.writeTo(this.context.currentBuffer());
                this.urls.add(imageDescriptor);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("not confluence resource: " + imageSource));
                }
                tag.writeTo(this.context.currentBuffer());
            }
        } else {
            log.warn((Object)("image tag has no src attribute: " + tag));
            tag.writeTo(this.context.currentBuffer());
        }
    }

    public Set getExtractedUrls() {
        return this.urls;
    }

    private boolean isConfluenceResource(String imageSource) {
        return imageSource.startsWith("/") || imageSource.startsWith(this.baseUrl);
    }
}

