/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.importexport.impl.ImportedObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;

class ImportedCollection {
    private String collectionName;
    private Class collectionElementClass;
    private ImportedObject object;

    public ImportedCollection(ImportedObject object) {
        this.object = object;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = this.correctCollectionName(collectionName);
    }

    public void setNextCollectionElementClass(Class collectionElementClass) {
        this.collectionElementClass = collectionElementClass;
    }

    public void addCollectionElementReference(String idStr) throws Exception {
        if (this.shouldPersistCollection()) {
            return;
        }
        TransientHibernateHandle key = this.object.readId(this.collectionElementClass, idStr);
        Object propertyValue = null;
        if (this.object.isPersistentObject(key)) {
            propertyValue = this.object.lookupPersistentObject(key);
        }
        if (propertyValue == null) {
            TransientHibernateHandle targetKey = new TransientHibernateHandle(this.object.getObjectClass(), this.object.getObjectId());
            this.object.getReverseDatabinder().deferAddCollectionElement(new TransientHibernateHandle[]{key, targetKey}, targetKey, this.collectionName, key);
        } else {
            ClassPersister persister = this.object.getPersister(this.object.getObjectClass());
            Collection collectionProperty = (Collection)persister.getPropertyValue(this.object.getObject(), this.collectionName);
            collectionProperty.add(propertyValue);
        }
    }

    public void initCollection(SessionImplementor session) throws HibernateException {
        if (this.shouldPersistCollection()) {
            return;
        }
        ClassPersister persister = this.object.getPersister(this.object.getObjectClass());
        Collection collection = (HashSet)persister.getPropertyValue(this.object.getObject(), this.collectionName);
        if (collection == null) {
            CollectionPersister collectionPersister;
            Type type = persister.getPropertyType(this.collectionName);
            collection = (Collection)((PersistentCollectionType)type).instantiate(session, collectionPersister = session.getFactory().getCollectionPersister(((PersistentCollectionType)type).getRole()));
            if (collection instanceof Set) {
                collection = new HashSet();
            } else if (collection instanceof List) {
                collection = new ArrayList();
            }
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.collectionName, collection);
        }
    }

    private boolean shouldPersistCollection() {
        return this.collectionName == null;
    }

    private String correctCollectionName(String propertyName) {
        if (Space.class.equals((Object)this.object.getObjectClass()) && ("pages".equals(propertyName) || "blogPosts".equals(propertyName) || "mail".equals(propertyName))) {
            return null;
        }
        if (Label.class.equals((Object)this.object.getObjectClass()) && "labellings".equals(propertyName)) {
            return null;
        }
        if (Page.class.equals((Object)this.object.getObjectClass()) && "permissions".equals(propertyName)) {
            return null;
        }
        if (Versioned.class.isAssignableFrom(this.object.getObjectClass()) && "previousVersions".equals(propertyName)) {
            return null;
        }
        return propertyName;
    }
}

