/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.confluence.core.persistence.hibernate.CustomClobType;
import com.atlassian.confluence.importexport.impl.ImportedObject;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.persistence.dao.hibernate.NamespaceUserType;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.persistence.dao.hibernate.CryptographicKeyType;
import com.atlassian.confluence.security.persistence.dao.hibernate.KeyTransferBean;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.persistence.dao.hibernate.SpaceTypeUserType;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.hibernate.BucketClobStringType;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.LiteralType;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.TextType;
import net.sf.hibernate.type.Type;

class ImportedProperty {
    private ImportedObject object;
    private String propertyName;
    private Class propertyClass;

    public ImportedProperty(ImportedObject object) {
        this.object = object;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = this.correctPropertyName(propertyName);
    }

    public Class getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(Class propertyClass) {
        this.propertyClass = propertyClass;
    }

    public void saveLiteralProperty(String propertyValueStr) throws HibernateException {
        ClassPersister persister = this.object.getPersister(this.object.getObjectClass());
        Type type = persister.getPropertyType(this.getPropertyName());
        if (type instanceof LiteralType) {
            if (type instanceof StringType || type instanceof TextType) {
                propertyValueStr = GeneralUtil.unescapeCDATA(propertyValueStr);
            }
            Object propertyValue = this.object.idFromString(type, propertyValueStr);
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, propertyValue);
        }
        if (type.getName().equals(BucketClobStringType.class.getName())) {
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, (Object)GeneralUtil.unescapeCDATA(propertyValueStr));
        }
        if (type.getName().equals(CustomClobType.class.getName())) {
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, (Object)GeneralUtil.unescapeCDATA(propertyValueStr));
        }
        if (type.getName().equals(NamespaceUserType.class.getName())) {
            String namespace = GeneralUtil.unescapeCDATA(propertyValueStr);
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, (Object)Namespace.getNamespace(namespace));
        }
        if (type.getName().equals(SpaceTypeUserType.class.getName())) {
            String spacetype = propertyValueStr;
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, (Object)SpaceType.getSpaceType(spacetype));
        }
        if (type.getName().equals(CryptographicKeyType.class.getName())) {
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.propertyName, (Object)new KeyTransferBean(KeyTransferBean.CDatafyString(propertyValueStr)).asKey());
        }
    }

    public void saveReferenceProperty(Session dbSession, String keyStr) throws Exception {
        TransientHibernateHandle key = this.object.readId(this.getPropertyClass(), keyStr);
        Object propertyValue = null;
        if (this.object.isPersistentObject(key)) {
            propertyValue = this.object.lookupPersistentObject(key);
        }
        if (propertyValue == null) {
            ClassMetadata md = dbSession.getSessionFactory().getClassMetadata(this.object.getObjectClass());
            boolean[] nullable = md.getPropertyNullability();
            String[] names = md.getPropertyNames();
            TransientHibernateHandle objectKey = new TransientHibernateHandle(this.object.getObjectClass(), this.object.getObjectId());
            boolean isNonNull = false;
            for (int i = 0; i < nullable.length; ++i) {
                if (!names[i].equals(this.getPropertyName()) || nullable[i]) continue;
                isNonNull = true;
                break;
            }
            if (isNonNull) {
                this.object.addNonNullPropertySetOperation(this.object.getReverseDatabinder().makeSetObjectPropertyOperation(this.object.getObject(), this.getPropertyName(), key));
            } else {
                this.object.getReverseDatabinder().deferSetObjectPropertyOnId(key, objectKey, this.getPropertyName());
            }
        } else {
            ClassPersister persister = this.object.getReverseDatabinder().getPersister(this.object.getObjectClass());
            ((ClassMetadata)persister).setPropertyValue(this.object.getObject(), this.getPropertyName(), propertyValue);
        }
    }

    private String correctPropertyName(String propertyName) {
        if (Attachment.class.equals((Object)this.object.getObjectClass()) && "page".equals(propertyName)) {
            return "content";
        }
        return propertyName;
    }
}

