/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.AbstractRendererExporterImpl;
import com.atlassian.confluence.importexport.impl.ImageProcessingRule;
import com.atlassian.confluence.importexport.impl.PdfImageProcessingRule;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.TemplateSupport;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.util.profiling.UtilTimerStack;
import com.icl.saxon.TransformerFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class PdfExporter
extends AbstractRendererExporterImpl {
    public static final Category log = Category.getInstance(PdfExporter.class);
    public static final Category pdfLog = Category.getInstance((String)"com.atlassian.confluence.importexport.impl.FopLogger");
    public static final Log4JLogger pdfLogger = new Log4JLogger((Logger)pdfLog);
    private FopFactory fopFactory;
    private String exportFileName;

    protected String getLinkPostfix() {
        return null;
    }

    protected boolean getLinkToExports() {
        return false;
    }

    protected String getLinkPrefix() {
        return "#";
    }

    public String doExport(ProgressMeter progress) throws ImportExportException {
        return super.doExport(progress) + "/" + this.exportFileName;
    }

    protected String getFullExportPath(String baseExportPath, ConfluenceEntityObject entity) {
        this.exportFileName = this.prepareExportFileName(entity) + ".pdf";
        return baseExportPath + "/" + this.exportFileName;
    }

    private TemplateSupport prepareExportTemplate(ConfluenceEntityObject entity) {
        TemplateSupport templateSupport = this.createTemplateSupport("pdfexport.vm");
        if (entity instanceof Space) {
            Space space = (Space)entity;
            templateSupport.putInContext("space", space);
            templateSupport.putInContext("contentTree", this.getWorkingExportContext().getContentTree());
        } else if (entity instanceof Page) {
            templateSupport.putInContext("page", entity);
        }
        templateSupport.setExportChildren(this.context.isExportHierarchy());
        return templateSupport;
    }

    protected void doExportEntity(ConfluenceEntityObject entity, String pdfFilePath) throws ImportExportException {
        String xslFoPath = pdfFilePath.substring(0, pdfFilePath.length() - 4) + ".fo";
        this.generateXslFo(entity, xslFoPath);
        this.foToPdf(new File(xslFoPath), new File(pdfFilePath));
    }

    protected ImageProcessingRule getImageProcessingRule(String exportDir) {
        return new PdfImageProcessingRule(this.settingsManager.getGlobalSettings().getBaseUrl(), exportDir);
    }

    private void foToPdf(File fo, File pdf) throws ImportExportException {
        OutputStream out = null;
        try {
            if (log.isDebugEnabled()) {
                this.logContentsOfFoFile(fo);
            }
            FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
            out = new FileOutputStream(pdf);
            out = new BufferedOutputStream(out);
            Fop fop = this.fopFactory.newFop("application/pdf", foUserAgent, out);
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(fo);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception e) {
            try {
                log.error((Object)"Error while generating PDF!", (Throwable)e);
                throw new ImportExportException("Error while generating PDF!", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContentsOfFoFile(File xslFo) throws IOException {
        StringBuffer buf;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(xslFo));
            buf = new StringBuffer(1024);
            while ((line = reader.readLine()) != null) {
                buf.append(line).append("\n");
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        log.debug((Object)buf.toString());
    }

    private void generateXslFo(ConfluenceEntityObject entity, String exportPath) throws ImportExportException {
        Writer writer = null;
        StringWriter stringWriter = new StringWriter();
        try {
            UtilTimerStack.push((String)(this.getClass() + ".generateXslFo"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(exportPath), "UTF-8"));
            this.prepareExportTemplate(entity).processTemplate(entity, stringWriter);
            this.exportImages(stringWriter.toString(), writer, new File(exportPath).getParent());
        }
        catch (Exception e) {
            throw new ImportExportException(e);
        }
        finally {
            UtilTimerStack.pop((String)(this.getClass() + ".generateXslFo"));
            try {
                stringWriter.close();
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing the writer!", (Throwable)e);
            }
        }
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }
}

