/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.impl.DefaultExportEmbeddedResourceRenderer;
import com.atlassian.confluence.importexport.impl.ExportLinkRenderer;
import com.atlassian.confluence.importexport.impl.XHtmlCSSIntegrator;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.WikiRenderException;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.XslUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.spring.container.ContainerManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.XMLWriter;
import org.w3c.tidy.Tidy;

public class WikiExporter {
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";
    private Category log = Category.getInstance(this.getClass());
    private WikiStyleRenderer wikiStyleRenderer;
    private IconManager iconManager;
    private Template xhtmlTemplate = null;
    private VelocityContext xhtmlContext = null;
    private XslUtil xslUtil = null;
    private XHtmlCSSIntegrator xhtmlCSSIntegrator = null;
    private DOMReader domReader = new DOMReader();
    private Tidy tidy = new Tidy();
    private SettingsManager settingsManager;
    private String linkPrefix;
    private String linkPostfix;
    private ExportContext exportContext;
    private String attachmentsPath;
    private boolean applyCssOnWikiText = true;
    private boolean linkToExports;
    private SubRenderer subRenderer;

    public WikiExporter() {
        this.tidy.setXHTML(true);
        this.tidy.setShowWarnings(false);
        this.tidy.setQuiet(true);
        this.tidy.setInputEncoding("UTF8");
        this.tidy.setOutputEncoding("UTF8");
        this.tidy.setFixUri(false);
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public String exportWikiToXHtml(ContentEntityObject content) {
        if (content == null || content.getContent() == null) {
            return "";
        }
        PageContext pageContext = content.toPageContext();
        pageContext.setOutputType("html_export");
        return this.exportWikiToXHtml(content.getContent(), pageContext);
    }

    public String exportWikiToXslFo(ContentEntityObject content) throws WikiRenderException {
        if (content == null || content.getContent() == null) {
            return "";
        }
        try {
            PageContext pageContext = content.toPageContext();
            pageContext.setOutputType("pdf");
            return this.exportWikiToXslFo(content.getContent(), pageContext);
        }
        catch (WikiRenderException e) {
            String name = "";
            if (content instanceof SpaceContentEntityObject) {
                name = ((SpaceContentEntityObject)content).getSpace().getKey() + ":" + content.getTitle();
            } else if (content instanceof PageContentEntityObject) {
                name = ((PageContentEntityObject)content).getPage().getSpace().getKey() + ":" + ((PageContentEntityObject)content).getPage().getTitle();
            }
            this.log.error((Object)("Error while generating XSL-FO for '" + name + "'"), (Throwable)e);
            throw new WikiRenderException("Error while generating XSL-FO for '" + name + "'", e);
        }
    }

    public String exportWikiToXHtml(String wiki, PageContext context) {
        DefaultExportEmbeddedResourceRenderer exportRenderer = new DefaultExportEmbeddedResourceRenderer();
        exportRenderer.setPermissionManager((PermissionManager)ContainerManager.getComponent((String)"permissionManager"));
        PageManager pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager");
        context.setImagePath("/images");
        context.setAttachmentsPath(this.attachmentsPath);
        context.setLinkRenderer(new ExportLinkRenderer(this.subRenderer, this.linkPrefix, this.linkPostfix, this.exportContext, this.iconManager, pageManager, this.linkToExports));
        context.setEmbeddedResourceRenderer(exportRenderer);
        context.setBaseUrl(this.settingsManager.getGlobalSettings().getBaseUrl());
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, wiki);
    }

    public String exportWikiToXslFo(String wiki, PageContext pageContext) throws WikiRenderException {
        String xhtml = null;
        try {
            this.initializePreliminaries();
            xhtml = this.exportWikiToXHtml(wiki, pageContext);
            return this.convertXHtmlToXslFo(xhtml);
        }
        catch (WikiRenderException e) {
            this.log.error((Object)("WIKI Style: " + wiki));
            this.log.error((Object)("XHTML Style: " + xhtml));
            throw e;
        }
        catch (Exception e) {
            throw new WikiRenderException(e);
        }
    }

    private void initializePreliminaries() throws Exception {
        if (this.xslUtil == null) {
            this.xslUtil = new XslUtil("xhtml2fo.xsl");
        }
        if (this.xhtmlCSSIntegrator == null) {
            this.xhtmlCSSIntegrator = new XHtmlCSSIntegrator();
        }
        if (this.xhtmlTemplate == null) {
            this.xhtmlTemplate = VelocityUtils.getTemplate("com/atlassian/confluence/importexport/xhtml.vm");
            this.xhtmlContext = new VelocityContext();
        }
    }

    private String convertXHtmlToXslFo(String xhtml) throws WikiRenderException {
        String processedXHtml = null;
        try {
            processedXHtml = this.initializeXHtml(xhtml);
            StreamSource source = new StreamSource(new StringReader(processedXHtml));
            DocumentResult result = new DocumentResult();
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
            if (baseUrl.indexOf(47) != -1) {
                baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47));
            }
            this.xslUtil.getTransformer().setParameter("urlPrefix", baseUrl);
            this.xslUtil.getTransformer().transform(source, (Result)result);
            Document dom4jDoc = result.getDocument();
            List nodes = dom4jDoc.selectNodes("//fo:root/fo:page-sequence/fo:flow/*");
            if (nodes.size() > 0) {
                Element element = (Element)nodes.get(0);
                this.fixXslFoTables(element);
                this.removeDuplicatedIds(element);
                return this.nativeToAscii(this.convertToString((Node)element));
            }
            this.log.warn((Object)"The exported XSL-FO doesn't seem to be valid. It doesn't contain 'fo:root/fo:page-sequence/fo:flow'!");
            return this.convertToString((Node)dom4jDoc);
        }
        catch (Exception e) {
            this.log.error((Object)("Can not transform XHTML to XSL-FO due to an error: " + processedXHtml), (Throwable)e);
            throw new WikiRenderException("Can not transform XHTML to XSL-FO due to an error in the following XHTML " + processedXHtml, e);
        }
    }

    private String initializeXHtml(String xhtml) throws Exception {
        if ((xhtml = this.stripComments(xhtml)) == null || xhtml.trim().equals("")) {
            xhtml = "&nbsp;";
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(xhtml.getBytes("UTF-8"));
        Document doc = this.domReader.read(this.tidy.parseDOM((InputStream)bis, (OutputStream)output));
        if (this.isApplyCssOnWikiText()) {
            this.xhtmlCSSIntegrator.applyStyleSheet((Node)doc.getRootElement());
        }
        xhtml = this.convertToString((Node)doc);
        xhtml = this.extractBody(xhtml);
        StringWriter writer = new StringWriter();
        this.xhtmlContext.put("xhtmlContent", (Object)xhtml);
        this.xhtmlTemplate.merge((Context)this.xhtmlContext, (Writer)writer);
        writer.flush();
        xhtml = writer.getBuffer().toString();
        bis.close();
        return xhtml;
    }

    private String extractBody(String xhtml) throws DocumentException, IOException {
        int index = xhtml.indexOf("<body");
        if (xhtml.indexOf("</body>", index = xhtml.indexOf(">", index) + 1) == -1) {
            return "";
        }
        xhtml = xhtml.substring(index, xhtml.indexOf("</body>", index));
        return xhtml;
    }

    public String stripComments(String xhtml) throws DocumentException, IOException {
        int startindex = 0;
        while ((startindex = xhtml.indexOf(START_COMMENT)) != -1) {
            int endindex = xhtml.indexOf(END_COMMENT, startindex);
            String preblock = xhtml.substring(0, startindex);
            String postblock = xhtml.substring(endindex + END_COMMENT.length());
            xhtml = preblock + postblock;
        }
        return xhtml;
    }

    private String convertToString(Node node) throws IOException {
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer);
        xmlWriter.write(node);
        String result = writer.toString();
        xmlWriter.close();
        writer.close();
        return result;
    }

    public String nativeToAscii(String text) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '\u0080') {
                buffer.append(chars[i]);
                continue;
            }
            if (chars[i] >= '\u0080' && chars[i] < '\u0100') {
                buffer.append("&#x00" + Integer.toString(chars[i], 16) + ";");
                continue;
            }
            buffer.append("&#x" + Integer.toString(chars[i], 16) + ";");
        }
        return buffer.toString();
    }

    private void removeDuplicatedIds(Element element) {
        Iterator it = element.selectNodes("//*/@id").iterator();
        Set processedIds = this.exportContext.getProcessedIds();
        while (it.hasNext()) {
            Attribute idAttribute = (Attribute)it.next();
            if (!processedIds.contains(idAttribute.getValue())) {
                processedIds.add(idAttribute.getValue());
                continue;
            }
            Element parentNode = idAttribute.getParent();
            parentNode.remove(idAttribute);
        }
    }

    private void fixXslFoTables(Element el) {
        List tableNodes = el.selectNodes("//fo:table");
        for (Element tableNode : tableNodes) {
            if (!tableNode.selectNodes("fo:table-column").isEmpty()) continue;
            int maxColCount = this.getMaximumTableColumnCount(tableNode);
            for (int i = 0; i < maxColCount; ++i) {
                tableNode.content().add(0, DocumentHelper.createElement((String)"fo:table-column").addAttribute("column-width", "proportional-column-width(1)"));
            }
        }
    }

    private int getMaximumTableColumnCount(Element tableElement) {
        Iterator it = tableElement.selectNodes("fo:table-body/fo:table-row").iterator();
        int maxColCount = 0;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            List cols = node.selectNodes("fo:table-cell");
            if (cols.size() <= maxColCount) continue;
            maxColCount = cols.size();
        }
        return maxColCount;
    }

    public void setLinkPrefix(String linkPrefix) {
        this.linkPrefix = linkPrefix;
    }

    public void setLinkPostfix(String linkPostfix) {
        this.linkPostfix = linkPostfix;
    }

    public void setExportContext(ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    public void setAttachmentsPath(String attachmentsPath) {
        this.attachmentsPath = attachmentsPath;
    }

    public boolean isApplyCssOnWikiText() {
        return this.applyCssOnWikiText;
    }

    public void setApplyCssOnWikiText(boolean applyCssOnWikiText) {
        this.applyCssOnWikiText = applyCssOnWikiText;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setLinkToExports(boolean linkToExports) {
        this.linkToExports = linkToExports;
    }
}

