/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.confluence.core.FileExportable;
import com.atlassian.confluence.core.NotExportable;
import com.atlassian.confluence.core.persistence.hibernate.CustomClobType;
import com.atlassian.confluence.importexport.ObjectHandleTranslator;
import com.atlassian.confluence.labels.persistence.dao.hibernate.NamespaceUserType;
import com.atlassian.confluence.security.persistence.dao.hibernate.CryptographicKeyType;
import com.atlassian.confluence.security.persistence.dao.hibernate.KeyTransferBean;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.core.util.StringUtils;
import com.atlassian.hibernate.BucketClobStringType;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.security.Key;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.BagType;
import net.sf.hibernate.type.DateType;
import net.sf.hibernate.type.ListType;
import net.sf.hibernate.type.MapType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.SetType;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.TimestampType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class XMLDatabinder {
    public static final String ISO_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    private SessionFactoryImplementor factory;
    private Set handles = new HashSet();
    private Set excludedObjects = new HashSet();
    private Set associatedHandles = new HashSet();
    private boolean initializeLazy = false;
    private String encoding;
    private static Category log = Category.getInstance(XMLDatabinder.class);
    private final ObjectHandleTranslator translator;
    private DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat isoTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LEFT_CHEVRON = "<";
    private static final String RIGHT_CHEVRON = ">";
    private static final String CARRIAGE_RETURN = "\n";
    private static final String START_CLOSE_TAG = "</";
    private static final String END_TAG_CARRIAGE_RETURN = ">\n";
    private static final String CONST_NAME = "name";
    private static final String CONST_CLASS = "class";
    private static final String CONST_COMPOSITE_ELEMENT = "composite-element";
    private static final String CONST_ELEMENT = "element";
    private static final String CONST_SUBCOLLECTION = "subcollection";
    private static final String CONST_ID = "id";
    private static final String CONST_COMPOSITE_ID = "composite-id";
    private static final String CONST_OPEN_OBJECT_TAG = "<object";
    private static final String CONST_CLOSE_OBJECT_TAG = "</object>\n";
    private static final String CONST_COLLECTION = "collection";
    private static final String CONST_PROPERTY = "property";
    private static final String CONST_COMPONENT = "component";
    private static final String CONST_TYPE = "type";
    private static final String CONST_OPEN_CDATA = "<![CDATA[";
    private static final String CONST_CLOSE_CDATA = "]]>";
    private Session session;
    private Transaction tx;
    private int count = 0;

    public XMLDatabinder(SessionFactoryImplementor factory, String encoding, ObjectHandleTranslator translator) {
        this.factory = factory;
        this.encoding = encoding;
        this.translator = translator;
    }

    private ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    public void setInitializeLazy(boolean initializeLazy) {
        this.initializeLazy = initializeLazy;
    }

    private void objectWritten() throws HibernateException {
        if (this.count++ % 100 == 0) {
            this.commit();
        }
    }

    private void commit() throws HibernateException {
        this.session.flush();
        this.session.clear();
        this.tx.commit();
        this.tx = this.session.beginTransaction();
    }

    private void startTxn() throws HibernateException {
        this.session = SessionFactoryUtils.getSession((SessionFactory)this.factory, (boolean)true);
        this.tx = this.session.beginTransaction();
        this.commit();
    }

    public void toGenericXML(Writer writer, ProgressMeter progress) throws HibernateException, IOException {
        this.startTxn();
        writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        String date = Hibernate.TIMESTAMP.toString((Object)new Date(), this.factory);
        writer.write("<hibernate-generic datetime=\"" + date + "\">\n");
        if (log.isDebugEnabled()) {
            log.debug((Object)("OUTSIDE ITERATOR::: System.currentTimeMillis() = " + System.currentTimeMillis() + " " + this.handles.size()));
        }
        List l = this.collectObjectGraph();
        int totalObjects = l.size();
        int currentCount = 0;
        progress.setTotalObjects(totalObjects + 1);
        Collections.sort(l, new ObjectComparator());
        Iterator iter = l.iterator();
        progress.setStatus("Writing export");
        while (iter.hasNext()) {
            Object key = iter.next();
            Object object = this.translator.handleToObject(key);
            if ((object = this.maybeInitializeIfProxy(object)) != null) {
                writer.write(CONST_OPEN_OBJECT_TAG);
                this.addClass(writer, object.getClass());
                writer.write(END_TAG_CARRIAGE_RETURN);
                ClassPersister persister = this.getPersister(object.getClass());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing object: " + persister.getClassName() + " with ID: " + persister.getIdentifier(object) + " to XML."));
                }
                if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                    Serializable id = persister.getIdentifier(object);
                    this.renderProperty(writer, persister.getIdentifierPropertyName(), persister.getIdentifierType(), id, CONST_COMPOSITE_ID, CONST_ID, null, false);
                }
                Type[] types = persister.getPropertyTypes();
                Object[] values = persister.getPropertyValues(object);
                String[] names = persister.getPropertyNames();
                for (int i = 0; i < types.length; ++i) {
                    block10: {
                        try {
                            if (types[i].isEntityType() && types[i].isAssociationType() && this.isExcluded(values[i])) {
                            }
                            break block10;
                        }
                        catch (RuntimeException onfe) {
                            log.warn((Object)("Object doesn't exist for property " + names[i] + " of " + key.toString()), onfe.getCause());
                        }
                        continue;
                    }
                    this.renderProperty(writer, names[i], types[i], values[i], CONST_COMPONENT, CONST_PROPERTY, CONST_COLLECTION, false);
                }
                writer.write(CONST_CLOSE_OBJECT_TAG);
            } else {
                log.warn((Object)("Null object found for key:" + key.toString()));
            }
            this.objectWritten();
            progress.setCurrentCount(++currentCount);
        }
        writer.write("</hibernate-generic>");
        this.commit();
        progress.setCurrentCount(totalObjects);
    }

    private void addClass(Writer writer, Class clazz) throws IOException {
        String className = clazz.getName();
        String unqualifiedClassName = StringHelper.unqualify((String)className);
        String packageName = StringHelper.qualifier((String)className);
        writer.write(" class=\"" + unqualifiedClassName + "\" package=\"" + packageName + "\"");
    }

    private Object maybeInitializeIfProxy(Object object) {
        if (!(object instanceof HibernateProxy)) {
            return object;
        }
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)((HibernateProxy)object));
        if (li.isUninitialized() && !this.initializeLazy) {
            return null;
        }
        return li.getImplementation();
    }

    public XMLDatabinder bind(Object object) {
        if (object instanceof TransientHibernateHandle) {
            this.handles.add(object);
        } else {
            this.handles.add(this.translator.objectToHandle(object));
        }
        return this;
    }

    public XMLDatabinder unbind(Object object) {
        if (object instanceof TransientHibernateHandle) {
            this.excludedObjects.add(object);
        } else {
            this.excludedObjects.add(this.translator.objectToHandle(object));
        }
        return this;
    }

    public XMLDatabinder bindAll(Collection objects) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            this.bind(i.next());
        }
        return this;
    }

    public XMLDatabinder unbindAll(Collection objects) {
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            this.unbind(iterator.next());
        }
        return this;
    }

    private void renderProperty(Writer writer, String name, Type type, Object value, String componentName, String propertyName, String collectionName, boolean doType) throws HibernateException, IOException {
        if (type.isComponentType()) {
            this.renderComponentType(writer, name, type, value, componentName, doType);
        } else if (type.isPersistentCollectionType()) {
            this.renderCollectionType(writer, name, type, value, collectionName, doType);
        } else if (type.isEntityType()) {
            this.renderEntityType(writer, name, type, value, propertyName, doType);
        } else {
            this.renderOtherType(writer, name, type, value, propertyName, doType);
        }
    }

    private void renderOtherType(Writer writer, String name, Type type, Object value, String propertyName, boolean doType) throws HibernateException, IOException {
        writer.write(LEFT_CHEVRON + propertyName);
        if (name != null) {
            this.appendAttribute(writer, CONST_NAME, name);
        }
        if (doType) {
            this.appendAttribute(writer, CONST_TYPE, type.getName());
        }
        if (value != null) {
            writer.write(RIGHT_CHEVRON);
            String xmlValue = type.toString(value, this.factory);
            if (type instanceof StringType || type.getName().equals(BucketClobStringType.class.getName()) || type.getName().equals(CustomClobType.class.getName()) || type.getName().equals(NamespaceUserType.class.getName())) {
                writer.write(CONST_OPEN_CDATA + GeneralUtil.escapeCDATA(StringUtils.escapeCP1252((String)xmlValue, (String)this.encoding)) + CONST_CLOSE_CDATA);
            } else if (type instanceof TimestampType) {
                writer.write(this.isoTimestampFormat.format((Date)value));
            } else if (type instanceof DateType) {
                writer.write(this.isoDateFormat.format((Date)value));
            } else if (type.getName().equals(CryptographicKeyType.class.getName())) {
                writer.write(new KeyTransferBean((Key)value).asCDataEncodedString());
            } else {
                writer.write(xmlValue);
            }
            writer.write(START_CLOSE_TAG + propertyName + END_TAG_CARRIAGE_RETURN);
        } else {
            writer.write("/>");
        }
    }

    private void appendAttribute(Writer writer, String attributeName, String attributeValue) throws IOException {
        writer.write(" " + attributeName + "=\"" + attributeValue + "\"");
    }

    private void renderEntityType(Writer writer, String name, Type type, Object value, String propertyName, boolean doType) throws HibernateException, IOException {
        if ((value = this.maybeInitializeIfProxy(value)) != null) {
            writer.write(LEFT_CHEVRON + propertyName);
            if (name != null) {
                this.appendAttribute(writer, CONST_NAME, name);
            }
            if (doType) {
                this.appendAttribute(writer, CONST_TYPE, type.getName());
            }
            this.addClass(writer, value.getClass());
            writer.write(RIGHT_CHEVRON);
            ClassPersister persister = this.getPersister(value.getClass());
            if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                Type idType = persister.getIdentifierType();
                Serializable id = persister.getIdentifier(value);
                this.renderProperty(writer, persister.getIdentifierPropertyName(), idType, id, CONST_COMPOSITE_ID, CONST_ID, null, false);
            }
            writer.write(START_CLOSE_TAG + propertyName + RIGHT_CHEVRON + CARRIAGE_RETURN);
        }
    }

    private void renderCollectionType(Writer writer, String name, Type type, Object value, String collectionName, boolean doType) throws HibernateException, IOException {
        int length;
        if (value == null) {
            return;
        }
        PersistentCollectionType collectiontype = (PersistentCollectionType)type;
        String role = collectiontype.getRole();
        CollectionPersister persister = this.factory.getCollectionPersister(role);
        if (persister.isArray() ? (length = Array.getLength(value)) == 0 : value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        if (persister.isArray()) {
            collectionName = "array";
        }
        writer.write(LEFT_CHEVRON + collectionName);
        if (name != null) {
            this.appendAttribute(writer, CONST_NAME, name);
        }
        if (!persister.isArray() && doType) {
            this.appendAttribute(writer, CONST_CLASS, type.getName());
        }
        Type elemType = persister.getElementType();
        writer.write(RIGHT_CHEVRON);
        if (persister.isArray()) {
            int length2 = Array.getLength(value);
            for (int i = 0; i < length2; ++i) {
                this.renderProperty(writer, null, elemType, Array.get(value, i), CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, false);
            }
        } else {
            boolean wasInitialized = false;
            if (value instanceof PersistentCollection) {
                PersistentCollection persistentCollection = (PersistentCollection)value;
                wasInitialized = persistentCollection.wasInitialized();
            }
            if (!persister.isLazy() || this.initializeLazy || wasInitialized) {
                if (type instanceof ListType) {
                    for (Object e : (List)value) {
                        if (this.isExcluded(e)) continue;
                        this.renderProperty(writer, null, elemType, e, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, false);
                    }
                } else if (type instanceof SetType || type instanceof BagType) {
                    for (Object e : (Collection)value) {
                        if (this.isExcluded(e)) continue;
                        this.renderProperty(writer, null, elemType, e, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, false);
                    }
                } else if (type instanceof MapType) {
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        Object collectionItem = entry.getValue();
                        if (this.isExcluded(collectionItem)) continue;
                        this.renderProperty(writer, null, elemType, collectionItem, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, false);
                    }
                }
            }
        }
        writer.write(START_CLOSE_TAG + collectionName + END_TAG_CARRIAGE_RETURN);
    }

    private boolean isExcluded(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.excludedObjects.contains(this.translator.objectToHandle(obj));
    }

    private void renderComponentType(Writer writer, String name, Type type, Object value, String componentName, boolean doType) throws HibernateException, IOException {
        if (value != null) {
            AbstractComponentType componenttype = (AbstractComponentType)type;
            writer.write(LEFT_CHEVRON + componentName);
            if (name != null) {
                this.appendAttribute(writer, CONST_NAME, name);
            }
            if (doType) {
                this.appendAttribute(writer, CONST_CLASS, type.getName());
            }
            writer.write(RIGHT_CHEVRON);
            String[] properties = componenttype.getPropertyNames();
            Object[] subvalues = componenttype.getPropertyValues(value, null);
            Type[] subtypes = componenttype.getSubtypes();
            for (int j = 0; j < properties.length; ++j) {
                this.renderProperty(writer, properties[j], subtypes[j], subvalues[j], CONST_COMPONENT, CONST_PROPERTY, CONST_COLLECTION, false);
            }
            writer.write(START_CLOSE_TAG + componentName + END_TAG_CARRIAGE_RETURN);
        }
    }

    public List collectObjectGraph() throws HibernateException {
        LinkedList extendedGraph = new LinkedList();
        while (this.handles.size() > 0) {
            for (Object handle : this.handles) {
                if (log.isDebugEnabled() && handle instanceof TransientHibernateHandle) {
                    log.debug((Object)("Expanding handle: " + handle));
                }
                this.expandEntity(this.translator.handleToObject(handle), extendedGraph);
            }
            this.handles.clear();
            this.handles.addAll(this.associatedHandles);
            this.associatedHandles.clear();
        }
        return extendedGraph;
    }

    private void expandEntity(Object entity, List extendedGraph) throws HibernateException {
        List<Class<?>> interfaces;
        if (entity == null) {
            return;
        }
        if ((entity = this.maybeInitializeIfProxy(entity)) == null) {
            return;
        }
        Object handle = this.translator.objectToHandle(entity);
        if (this.isExcluded(entity) || extendedGraph.contains(handle)) {
            return;
        }
        Class handleClass = handle.getClass();
        if (handle instanceof TransientHibernateHandle) {
            handleClass = ((TransientHibernateHandle)handle).getClazz();
        }
        if ((interfaces = Arrays.asList(handleClass.getInterfaces())).contains(FileExportable.class) || interfaces.contains(NotExportable.class)) {
            return;
        }
        extendedGraph.add(handle);
        ClassPersister persister = this.getPersister(entity.getClass());
        Type[] types = persister.getPropertyTypes();
        Object[] values = persister.getPropertyValues(entity);
        for (int i = 0; i < types.length; ++i) {
            boolean shouldTraverseCollection;
            PersistentCollectionType collectiontype;
            String role;
            CollectionPersister collectionPersister;
            Type collectionType;
            Type type = types[i];
            if (type.isEntityType()) {
                Object value = values[i];
                this.associatedObjectFound(value);
                continue;
            }
            if (!type.isPersistentCollectionType() || !(collectionType = (collectionPersister = this.factory.getCollectionPersister(role = (collectiontype = (PersistentCollectionType)type).getRole())).getElementType()).isEntityType()) continue;
            Object value = values[i];
            boolean wasInitialized = false;
            if (value instanceof PersistentCollection) {
                PersistentCollection persistentCollection = (PersistentCollection)value;
                wasInitialized = persistentCollection.wasInitialized();
            }
            boolean bl = shouldTraverseCollection = !collectionPersister.isLazy() || this.initializeLazy || wasInitialized;
            if (!shouldTraverseCollection) continue;
            if (collectionPersister.isArray()) {
                int length = Array.getLength(value);
                for (int j = 0; j < length; ++j) {
                    Object v = Array.get(value, j);
                    this.associatedObjectFound(v);
                }
                continue;
            }
            for (Object v : (Collection)value) {
                this.associatedObjectFound(v);
            }
        }
        this.objectWritten();
    }

    private void associatedObjectFound(Object object) {
        if (object == null) {
            return;
        }
        if ((object = this.maybeInitializeIfProxy(object)) != null) {
            this.associatedHandles.add(this.translator.objectToHandle(object));
        }
    }

    private class ObjectComparator
    implements Comparator {
        private ObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class classB;
            Class classA = o1 instanceof TransientHibernateHandle ? ((TransientHibernateHandle)o1).getClazz() : o1.getClass();
            Class clazz = classB = o2 instanceof TransientHibernateHandle ? ((TransientHibernateHandle)o2).getClazz() : o2.getClass();
            if (classB == BucketPropertySetItem.class) {
                return -1;
            }
            if (classA == BucketPropertySetItem.class) {
                return 1;
            }
            return 0;
        }
    }
}

