/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.FileXmlExporter;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.bandana.persistence.dao.ConfluenceBandanaRecordDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import java.util.ArrayList;
import java.util.List;

public class XmlExporter
extends FileXmlExporter {
    private ConfluenceBandanaRecordDao confluenceBandanaRecordDao;

    public String doExport(ProgressMeter progress) throws ImportExportException {
        this.checkHaveSomethingToExport();
        return super.doExport(progress);
    }

    protected List getIncludedSpaces() {
        ArrayList<ConfluenceEntityObject> spacesList = new ArrayList<ConfluenceEntityObject>();
        ConfluenceEntityObject mainWorkingEntity = this.getMainWorkingEntity();
        if (mainWorkingEntity instanceof Space) {
            spacesList.add(mainWorkingEntity);
        } else if (mainWorkingEntity instanceof AbstractPage) {
            spacesList.add(((AbstractPage)mainWorkingEntity).getSpace());
        }
        return spacesList;
    }

    protected List getSourceTemplateDirForCopying() {
        return new ArrayList();
    }

    private ConfluenceEntityObject getMainWorkingEntity() {
        return (ConfluenceEntityObject)this.getWorkingExportContext().getWorkingEntities().get(0);
    }

    protected List getHandlesOfObjectsForExport() throws ImportExportException {
        List workingEntities = this.getWorkingExportContext().getWorkingEntities();
        if (workingEntities == null || workingEntities.isEmpty()) {
            throw new ImportExportException("Nothing to export!");
        }
        ArrayList<ConfluenceEntityObject> result = new ArrayList<ConfluenceEntityObject>();
        for (ConfluenceEntityObject confluenceEntityObject : workingEntities) {
            if (confluenceEntityObject instanceof Space) {
                Space space = (Space)confluenceEntityObject;
                result.add(space);
                result.addAll(this.getContentAndContentPropertiesFromSpace(space));
                result.addAll(this.confluenceBandanaRecordDao.findForContext(space.getKey()));
                continue;
            }
            if (!(confluenceEntityObject instanceof ContentEntityObject)) continue;
            result.add(confluenceEntityObject);
            this.addPropertiesForContent(result, (ContentEntityObject)confluenceEntityObject);
        }
        return result;
    }

    protected List getObjectsExcludedFromExport() throws ImportExportException {
        Space space;
        List exceptionEntities = super.getObjectsExcludedFromExport();
        ArrayList<ConfluenceEntityObject> excludedObjects = new ArrayList<ConfluenceEntityObject>(exceptionEntities);
        ConfluenceEntityObject mainWorkingEntity = this.getMainWorkingEntity();
        if (mainWorkingEntity instanceof Page) {
            Page page = (Page)mainWorkingEntity;
            excludedObjects.add(page.getSpace());
        } else if (mainWorkingEntity instanceof Space && (space = (Space)mainWorkingEntity).getSpaceGroup() != null) {
            excludedObjects.add(space.getSpaceGroup());
        }
        return excludedObjects;
    }

    public void setConfluenceBandanaRecordDao(ConfluenceBandanaRecordDao dao) {
        this.confluenceBandanaRecordDao = dao;
    }
}

