/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl.snipsnap;

import java.util.regex.Pattern;

public class RegExpProcessor {
    private Pattern pattern;
    private String substitute;

    public RegExpProcessor(String pattern, String substitute) {
        this.pattern = Pattern.compile(pattern);
        this.substitute = substitute;
    }

    public String process(String input) {
        if (input == null) {
            return null;
        }
        return this.pattern.matcher(input).replaceAll(this.substitute);
    }

    public String toString() {
        return "Pattern: [" + this.getPattern() + "]  Substitute: [" + this.getSubstitute() + "]";
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public String getSubstitute() {
        return this.substitute;
    }
}

