/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl.snipsnap;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.Importer;
import com.atlassian.confluence.importexport.impl.snipsnap.BlogTidier;
import com.atlassian.confluence.importexport.impl.snipsnap.ContentCleaner;
import com.atlassian.confluence.importexport.impl.snipsnap.SnipSnapSnip;
import com.atlassian.confluence.importexport.impl.snipsnap.SnipSnapUser;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.RegExpProcessor;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class SnipSnapImporter
extends Importer {
    protected PageManager pageManager;
    protected UserAccessor userAccessor;
    protected ConfluenceIndexer indexer;
    private Space space;
    private CommentManager commentManager;
    private ReferralManager referralManager;
    private LinkManager linkManager;
    private ContentCleaner contentCleaner = new ContentCleaner();
    private PersonalInformationManager personalInformationManager;
    private RegExpProcessor regExpProcessor = new RegExpProcessor("\\[([^:\\[\\]]+)\\]", null);
    private static List snipsnapIgnoredPagesList = new ArrayList();

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public void doImport() throws ImportExportException {
        DefaultImportContext defaultImportContext = (DefaultImportContext)this.context;
        this.space = defaultImportContext.getDefaultSpace();
        String snipSnapExportPath = defaultImportContext.getWorkingFile();
        File snipSnapExport = new File(snipSnapExportPath);
        if (!snipSnapExport.isFile()) {
            throw new ImportExportException("Invalid export file specified.");
        }
        ProgressMeter progress = this.context.getProgressMeter();
        progress.setPercentage(0);
        progress.setStatus("Starting import and parsing XML file...");
        this.importAll(snipSnapExport, progress);
        if (defaultImportContext.isDeleteWorkingFile()) {
            progress.setStatus("Deleting import file.");
            snipSnapExport.delete();
        }
        progress.setPercentage(100);
        progress.setStatus("Import complete.");
    }

    private void importAll(File snipSnapExport, ProgressMeter progress) {
        ArrayList objects = new ArrayList();
        Digester digester = new Digester();
        digester.push(objects);
        digester.addObjectCreate("snipspace/user", SnipSnapUser.class);
        digester.addBeanPropertySetter("snipspace/user/login", "login");
        digester.addBeanPropertySetter("snipspace/user/email", "email");
        digester.addBeanPropertySetter("snipspace/user/roles", "roles");
        digester.addSetNext("snipspace/user", "add");
        digester.addObjectCreate("snipspace/snip", SnipSnapSnip.class);
        digester.addBeanPropertySetter("snipspace/snip/name", "name");
        digester.addBeanPropertySetter("snipspace/snip/content", "content");
        digester.addBeanPropertySetter("snipspace/snip/cTime", "created");
        digester.addBeanPropertySetter("snipspace/snip/mTime", "modified");
        digester.addBeanPropertySetter("snipspace/snip/cUser", "creator");
        digester.addBeanPropertySetter("snipspace/snip/mUser", "modifier");
        digester.addBeanPropertySetter("snipspace/snip/backLinks", "backLinks");
        digester.addBeanPropertySetter("snipspace/snip/attachments", "attachments");
        digester.addSetNext("snipspace/snip", "add");
        try {
            FileInputStream fis = new FileInputStream(snipSnapExport);
            digester.parse((InputStream)fis);
        }
        catch (IOException e) {
            throw new InfrastructureException("Error reading SnipSnap import file!", (Throwable)e);
        }
        catch (SAXException e) {
            throw new InfrastructureException("Error parsing SnipSnap import file!", (Throwable)e);
        }
        progress.setPercentage(5);
        progress.setStatus("Parsed XML import file...");
        BlogTidier.tidyBlogs(objects);
        progress.setTotalObjects(objects.size());
        Map importedUsers = this.importUsers(progress, objects);
        this.importSnips(progress, objects, importedUsers);
    }

    private Map importUsers(ProgressMeter progress, List objects) {
        HashMap<String, User> usersImported = new HashMap<String, User>();
        for (Object o : objects) {
            if (!(o instanceof SnipSnapUser)) continue;
            progress.setCurrentCount(progress.getCurrentCount() + 1);
            this.updatePercentageComplete(progress, 10);
            progress.setStatus("Importing user " + progress.getCurrentCount() + " of " + progress.getTotal() + " total objects.");
            SnipSnapUser snipSnapUser = (SnipSnapUser)o;
            User user = this.userAccessor.getUser(snipSnapUser.getLogin());
            if (user == null) {
                user = this.importUser(snipSnapUser);
                usersImported.put(snipSnapUser.getLogin().toLowerCase(), user);
                continue;
            }
            this.log.warn((Object)("User " + snipSnapUser.getLogin() + " not imported - user already exists"));
        }
        return usersImported;
    }

    private User importUser(SnipSnapUser snipSnapUser) {
        Group admins;
        String roles;
        User user = this.userAccessor.addUser(snipSnapUser.getLogin(), RandomGenerator.randomPassword(), snipSnapUser.getEmail(), snipSnapUser.getLogin(), null);
        Group users = this.userAccessor.getGroupCreateIfNecessary("confluence-users");
        if (!this.userAccessor.hasMembership(users, user)) {
            this.userAccessor.addMembership(users, user);
        }
        if (StringUtils.isNotBlank((String)snipSnapUser.getRoles()) && (roles = snipSnapUser.getRoles()).toLowerCase().indexOf("admin") >= 0 && !this.userAccessor.hasMembership(admins = this.userAccessor.getGroupCreateIfNecessary("confluence-administrators"), user)) {
            this.userAccessor.addMembership(admins, user);
        }
        return user;
    }

    private void importSnips(ProgressMeter progress, List objects, Map importedUsers) {
        ArrayList<SnipSnapSnip> comments = new ArrayList<SnipSnapSnip>();
        HashMap<String, AbstractPage> pages = new HashMap<String, AbstractPage>();
        HashMap renamedPages = new HashMap();
        ArrayList<ContentEntityObject> contentEntities = new ArrayList<ContentEntityObject>();
        for (Object o : objects) {
            if (!(o instanceof SnipSnapSnip)) continue;
            progress.setCurrentCount(progress.getCurrentCount() + 1);
            this.updatePercentageComplete(progress, 10);
            progress.setStatus("Importing snip " + progress.getCurrentCount() + " of " + progress.getTotal() + " total objects.");
            SnipSnapSnip snip = (SnipSnapSnip)o;
            String snipName = snip.getName();
            if (snipName.startsWith("comment-")) {
                if (importedUsers.get(this.getCommentedPageName(snip).toLowerCase()) != null) continue;
                comments.add(snip);
                continue;
            }
            User importedUser = (User)importedUsers.get(snipName.toLowerCase());
            User userInDb = this.userAccessor.getUser(snipName.toLowerCase());
            if (importedUser != null) {
                this.importUserDescription(snip, importedUser);
                continue;
            }
            if (userInDb != null || snipsnapIgnoredPagesList.contains(snipName)) continue;
            AbstractPage page = this.importPage(snip, renamedPages);
            pages.put(snipName, page);
            contentEntities.add(page);
        }
        progress.setStatus("Importing comments... ");
        int count = 1;
        for (SnipSnapSnip snip : comments) {
            String message = "importing comment " + count++ + " of " + comments.size();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)message);
            }
            progress.setStatus(message);
            Comment comment = this.importComment(snip, pages);
            if (comment == null) continue;
            contentEntities.add(comment);
        }
        this.fixLinks(progress, contentEntities, renamedPages);
        this.saveRenamedPagesReport(renamedPages, pages);
        this.updatePercentageComplete(progress, 20);
        progress.setStatus("Relinking entities... ");
        count = 1;
        Iterator iterator = contentEntities.iterator();
        while (iterator.hasNext()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("relinking entity " + count++ + " of " + contentEntities.size()));
            }
            ContentEntityObject contentEntityObject = (ContentEntityObject)iterator.next();
            this.linkManager.updateOutgoingLinks(contentEntityObject);
        }
        if (pages.containsKey("start")) {
            this.space.setHomePage((Page)pages.get("start"));
        }
    }

    private void fixLinks(ProgressMeter progress, List contentEntities, HashMap renamedPages) {
        int count = 1;
        progress.setStatus("Updating links to users...");
        for (int i = 0; i < contentEntities.size(); ++i) {
            String message = "Renaming links for " + count++ + " of " + contentEntities.size() + " objects";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)message);
            }
            progress.setStatus(message);
            ContentEntityObject contentEntity = (ContentEntityObject)contentEntities.get(i);
            if (contentEntity != null) {
                String originalContent;
                String newContent = originalContent = contentEntity.getContent();
                newContent = this.fixLinksToRenamedPages(renamedPages, newContent);
                if (originalContent.equals(newContent = this.fixLinksToUsers(newContent))) continue;
                this.log.info((Object)("Fixed links for page/blog : " + contentEntity.getTitle()));
                contentEntity.setContent(newContent);
                continue;
            }
            this.log.warn((Object)("Content entity " + i + " was nulll"));
        }
    }

    private String fixLinksToUsers(String content) {
        Pager users = this.userAccessor.getUsers();
        String newContent = content;
        while (users.iterator().hasNext()) {
            User user = (User)users.iterator().next();
            String name = user.getName();
            newContent = newContent.replaceAll("\\[" + name + "\\]", "[~" + name + "]");
        }
        return newContent;
    }

    private String fixLinksToRenamedPages(HashMap renamedPages, String newContent) {
        for (String oldName : renamedPages.keySet()) {
            String newName = (String)renamedPages.get(oldName);
            try {
                newContent = newContent.replaceAll("\\[" + oldName + "\\]", "[" + newName + "]");
            }
            catch (Exception e) {
                this.log.error((Object)("Error fixing link to a renamed page: oldName: " + oldName + ", newName: " + newName));
            }
        }
        return newContent;
    }

    private void saveRenamedPagesReport(Map renamedPages, Map importedPages) {
        StringBuffer buf = new StringBuffer("The following SnipSnap Snips were renamed: \n\n\n");
        buf.append("||No.||Type||Original Name||Final Name|| \n");
        int count = 1;
        for (String oldName : renamedPages.keySet()) {
            String newName = (String)renamedPages.get(oldName);
            AbstractPage snip = (AbstractPage)importedPages.get(oldName);
            if (snip.getType().equals("page")) {
                buf.append("|").append(count++).append("|Page|*").append(oldName).append("*|[").append(newName).append("]| \n");
                continue;
            }
            if (!snip.getType().equals("blogpost")) continue;
            String datePath = ((BlogPost)snip).getDatePath();
            buf.append("|").append(count++).append("|Blog|*").append(oldName).append("*|[").append(datePath).append("/").append(newName).append("]| \n");
        }
        Page page = new Page();
        page.setContent(buf.toString());
        page.setSpace(this.space);
        Date now = new Date();
        page.setTitle("All Pages Renamed During SnipSnap Import On " + new SimpleDateFormat("yyyy-MM-dd HHmma").format(now));
        this.pageManager.saveContentEntity(page, null);
        page.setLastModificationDate(now);
        page.setCreationDate(now);
        String username = this.context.getCurrentUser().getName();
        page.setCreatorName(username);
        page.setLastModifierName(username);
    }

    private PersonalInformation importUserDescription(SnipSnapSnip snip, User user) {
        PersonalInformation info = this.personalInformationManager.getPersonalInformation(user);
        info.setContent(this.getCleanedUserDescription(snip));
        info.setFullName(user.getFullName());
        this.personalInformationManager.savePersonalInformation(info, null);
        this.importMetaData(info, snip);
        return info;
    }

    private AbstractPage importPage(SnipSnapSnip snip, HashMap renamedPages) {
        AbstractPage p = snip.getPageObject();
        p.setSpace(this.space);
        p.setCreationDate(new Date(snip.getCreated()));
        p.setTitle(this.mungeTitle(p, snip.getName(), renamedPages));
        p.setContent(this.getCleanedContent(snip));
        this.pageManager.saveContentEntity(p, null);
        this.importMetaData(p, snip);
        this.importBackLinks(p, snip);
        return p;
    }

    private String mungeTitle(AbstractPage page, String name, HashMap renamedPages) {
        if (AbstractPage.isValidPageTitle(name) && !this.alreadyExists(page, name)) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name.replaceAll("&", "and"));
        for (int i = 0; i < buf.length(); ++i) {
            if (AbstractPage.isValidPageTitleCharacter(buf.charAt(i))) continue;
            buf.setCharAt(i, '-');
        }
        while (this.alreadyExists(page, buf.toString())) {
            buf.append('-');
        }
        String newName = buf.toString();
        renamedPages.put(name, newName);
        this.log.warn((Object)("Renamed snip [" + name + "] to Confluence page [" + newName + "]"));
        return newName;
    }

    private boolean alreadyExists(AbstractPage page, String name) {
        if (page.getType().equals("page")) {
            return this.pageManager.getPage(this.space.getKey(), name) != null;
        }
        if (page.getType().equals("blogpost")) {
            return this.pageManager.getBlogPost(this.space.getKey(), name, BlogPost.toCalendar(page.getCreationDate())) != null;
        }
        return false;
    }

    private Comment importComment(SnipSnapSnip snip, Map pages) {
        String pageName = this.getCommentedPageName(snip);
        AbstractPage p = (AbstractPage)pages.get(pageName);
        if (p != null) {
            Comment c = this.commentManager.addCommentToPage(p, null, this.getCleanedContent(snip));
            this.importMetaData(c, snip);
            this.importBackLinks(c, snip);
            return c;
        }
        this.log.error((Object)("Page was null looking for " + pageName + "?"));
        return null;
    }

    private String getCommentedPageName(SnipSnapSnip snip) {
        String pageName = snip.getName().substring(snip.getName().indexOf(45) + 1);
        pageName = pageName.substring(0, pageName.lastIndexOf(45));
        return pageName;
    }

    private void importBackLinks(ContentEntityObject contentEntityObject, SnipSnapSnip snip) {
        String backLinks = snip.getBackLinks();
        if (!TextUtils.stringSet((String)backLinks)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(backLinks, "|");
        while (st.hasMoreTokens()) {
            String backLinkAndViews = st.nextToken();
            if (backLinkAndViews.indexOf(58) < 0) {
                this.log.warn((Object)("Error importing backlink, no : view separator: " + backLinkAndViews));
                continue;
            }
            String backLink = backLinkAndViews.substring(0, backLinkAndViews.lastIndexOf(58));
            int views = 1;
            try {
                views = Integer.parseInt(backLinkAndViews.substring(backLinkAndViews.lastIndexOf(58) + 1));
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Error reading referrer views from: " + backLinkAndViews.substring(backLinkAndViews.lastIndexOf(58) + 1)));
            }
            ReferralLink referral = new ReferralLink();
            if (backLink.length() >= 255) {
                this.log.warn((Object)("Backlink : " + backLink + " is longer than 255 chars - truncating."));
                backLink = backLink.substring(0, 253);
            }
            referral.setUrl(backLink);
            referral.setViewCount(views);
            referral.setSourceContent(contentEntityObject);
            this.referralManager.saveReferralLink(referral);
        }
    }

    private void importMetaData(ContentEntityObject content, SnipSnapSnip snip) {
        content.setCreationDate(new Date(snip.getCreated()));
        content.setCreatorName(snip.getCreator());
        content.setLastModificationDate(new Date(snip.getModified()));
        content.setLastModifierName(snip.getModifier());
    }

    private String getCleanedUserDescription(SnipSnapSnip snip) {
        this.regExpProcessor.setSubstitute("[" + this.space.getKey() + ":$1]");
        return this.regExpProcessor.process(this.getCleanedContent(snip));
    }

    private String getCleanedContent(SnipSnapSnip snip) {
        return this.contentCleaner.clean(snip.getContent());
    }

    private void updatePercentageComplete(ProgressMeter progress, int nonObjectPercentage) {
        progress.setPercentage(nonObjectPercentage + progress.getCurrentCount() * 70 / progress.getTotal());
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    static {
        snipsnapIgnoredPagesList.add("snipsnap-index");
        snipsnapIgnoredPagesList.add("snipsnap-search");
        snipsnapIgnoredPagesList.add("snipsnap-notfound");
        snipsnapIgnoredPagesList.add("snipsnap-copyright");
        snipsnapIgnoredPagesList.add("snipsnap-help");
        snipsnapIgnoredPagesList.add("snipsnap-about");
    }
}

