/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.resource.AttachmentDownloadResourceReader;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.FileServerServlet;
import com.atlassian.confluence.servlet.download.AttachmentUrlParser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.core.io.InputStreamSource;

public class AttachmentDownloadResourceManager
implements DownloadResourceManager {
    private AttachmentUrlParser attachmentUrlParser;
    private AttachmentManager attachmentManager;
    private PermissionManager permissionManager;
    private UserAccessor userAccessor;

    public boolean matches(String resourcePath) {
        return resourcePath.indexOf(FileServerServlet.SERVLET_PATH + "/" + "attachments") != -1;
    }

    public DownloadResourceReader getResourceReader(String userName, String resourcePath, Map parameters) throws UnauthorizedDownloadResourceException, DownloadResourceNotFoundException {
        Attachment attachment = this.getAttachment(userName, resourcePath, parameters, "attachments");
        return new AttachmentDownloadResourceReader(attachment, new AttachmentInputStreamSource(attachment));
    }

    protected Attachment getAttachment(String userName, String resourcePath, Map parameters, String urlPrefix) throws DownloadResourceNotFoundException, UnauthorizedDownloadResourceException {
        ContentEntityObject entity = this.attachmentUrlParser.getEntity(resourcePath, urlPrefix);
        if (entity == null || entity.getContentStatus().equals("deleted")) {
            throw new DownloadResourceNotFoundException();
        }
        if (!this.hasUserPrivilegeForDownload(userName, entity)) {
            throw new UnauthorizedDownloadResourceException("User is unauthorised to download atttachment");
        }
        Attachment attachment = this.attachmentUrlParser.getAttachment(resourcePath, urlPrefix, parameters);
        if (attachment == null) {
            throw new DownloadResourceNotFoundException();
        }
        return attachment;
    }

    public void setAttachmentUrlParser(AttachmentUrlParser attachmentUrlParser) {
        this.attachmentUrlParser = attachmentUrlParser;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    private boolean hasUserPrivilegeForDownload(String userName, ContentEntityObject entity) {
        User user = null;
        if (TextUtils.stringSet((String)userName)) {
            user = this.userAccessor.getUser(userName);
        }
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return false;
        }
        return this.permissionManager.hasPermission(user, Permission.VIEW, entity);
    }

    private class AttachmentInputStreamSource
    implements InputStreamSource {
        private Attachment attachment;

        public AttachmentInputStreamSource(Attachment attachment) {
            this.attachment = attachment;
        }

        public InputStream getInputStream() throws IOException {
            return AttachmentDownloadResourceManager.this.attachmentManager.getAttachmentData(this.attachment);
        }
    }
}

