/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DelegatorDownloadResourceManager
implements DownloadResourceManager {
    private static final Logger log = Logger.getLogger(DelegatorDownloadResourceManager.class);
    private List downloadResourceManagers;

    public boolean matches(String resourcePath) {
        for (DownloadResourceManager downloadResourceManager : this.downloadResourceManagers) {
            if (!downloadResourceManager.matches(resourcePath)) continue;
            return true;
        }
        return false;
    }

    public DownloadResourceReader getResourceReader(String userName, String resourcePath, Map parameters) throws DownloadResourceNotFoundException, UnauthorizedDownloadResourceException {
        for (DownloadResourceManager downloadResourceManager : this.downloadResourceManagers) {
            if (!downloadResourceManager.matches(resourcePath)) continue;
            return downloadResourceManager.getResourceReader(userName, resourcePath, parameters);
        }
        log.info((Object)("No download resource manager found for: " + resourcePath));
        return null;
    }

    public void setDownloadResourceManagers(List downloadResourceManagers) {
        this.downloadResourceManagers = downloadResourceManagers;
    }
}

