/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.importexport.resource.AttachmentDownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.ThumbnailDownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.servlet.FileServerServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.core.io.InputStreamSource;

public class ThumbnailDownloadResourceManager
extends AttachmentDownloadResourceManager {
    private ThumbnailManager thumbnailManager;

    public boolean matches(String resourcePath) {
        return resourcePath.indexOf(FileServerServlet.SERVLET_PATH + "/" + "thumbnails") != -1;
    }

    public DownloadResourceReader getResourceReader(String userName, String resourcePath, Map parameters) throws UnauthorizedDownloadResourceException, DownloadResourceNotFoundException {
        Attachment attachment = this.getAttachment(userName, resourcePath, parameters, "thumbnails");
        File thumbnailFile = this.thumbnailManager.getThumbnailFile(attachment);
        try {
            this.thumbnailManager.getThumbnail(attachment);
            return new ThumbnailDownloadResourceReader(attachment, thumbnailFile, new ThumbnailInputStreamSource(attachment));
        }
        catch (IOException e) {
            throw new DownloadResourceNotFoundException("Thumbnail file could not be found: " + thumbnailFile, e);
        }
    }

    public void setThumbnailManager(ThumbnailManager thumbnailManager) {
        this.thumbnailManager = thumbnailManager;
    }

    private class ThumbnailInputStreamSource
    implements InputStreamSource {
        private Attachment attachment;

        public ThumbnailInputStreamSource(Attachment attachment) {
            this.attachment = attachment;
        }

        public InputStream getInputStream() throws IOException {
            return ThumbnailDownloadResourceManager.this.thumbnailManager.getThumbnailData(this.attachment);
        }
    }
}

