/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.ResourceAccessor;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.importexport.resource.WebImagesDownloadResourceReader;
import com.atlassian.confluence.setup.BootstrapManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.core.io.InputStreamSource;

public class WebImagesDownloadResourceManager
implements DownloadResourceManager {
    private ResourceAccessor resourceAccessor;
    private BootstrapManager bootstrapManager;
    private static final String WEB_IMAGES_PATH = "/images";

    public boolean matches(String resourcePath) {
        return resourcePath.startsWith(this.bootstrapManager.getWebAppContextPath() + WEB_IMAGES_PATH);
    }

    public DownloadResourceReader getResourceReader(String userName, String resourcePath, Map parameters) throws UnauthorizedDownloadResourceException, DownloadResourceNotFoundException {
        String relativeResourcePath = resourcePath.substring(resourcePath.indexOf(WEB_IMAGES_PATH));
        return new WebImagesDownloadResourceReader(resourcePath, new WebImagesInputStreamSource(relativeResourcePath));
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    private class WebImagesInputStreamSource
    implements InputStreamSource {
        private String resourcePath;

        public WebImagesInputStreamSource(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public InputStream getInputStream() throws IOException {
            return WebImagesDownloadResourceManager.this.resourceAccessor.getResource(this.resourcePath);
        }
    }
}

