/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;

public class LabelParser {
    public static final char[] INVALID_CHARACTERS = new char[]{':', ';', ',', '.', ' ', '?', '&', '[', ']', '(', ')', '#', '^', '*', '@', '!', '<', '>'};
    public static final int MAX_LABEL_NAME_LENGTH = 255;
    public static final int MAX_LABEL_PREFIX_LENGTH = 255;
    public static final String PERSONAL_LABEL_PREFIX = "my:";
    public static final String TEAM_LABEL_PREFIX = "team:";
    public static final String NAMESPACE_DELIMITER = ":";
    public static final String USER_LABEL_PREFIX = "~";

    private static boolean isValidLabelName(String name) {
        char[] chars;
        for (char c : chars = name.toCharArray()) {
            if (!Character.isWhitespace(c) && !LabelParser.isInvalidCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidCharacter(char c) {
        return Arrays.binarySearch(INVALID_CHARACTERS, c) >= 0;
    }

    public static boolean isValidLabelLength(ParsedLabelName labelName) {
        return LabelParser.isValidNameLength(labelName) && LabelParser.isValidPrefixLength(labelName);
    }

    public static boolean isValidNameLength(ParsedLabelName labelName) {
        return labelName.getName().length() <= 255;
    }

    public static boolean isValidPrefixLength(ParsedLabelName labelName) {
        return labelName.getPrefix() == null || labelName.getPrefix().length() <= 255;
    }

    public static ParsedLabelName parse(String labelString) {
        String labelName;
        String userName = null;
        String prefix = null;
        if (labelString.toLowerCase().startsWith(PERSONAL_LABEL_PREFIX)) {
            User user = AuthenticatedUserThreadLocal.getUser();
            if (user == null) {
                return null;
            }
            userName = user.getName();
            labelName = labelString.substring(PERSONAL_LABEL_PREFIX.length());
            prefix = PERSONAL_LABEL_PREFIX;
        } else if (labelString.startsWith(USER_LABEL_PREFIX)) {
            int index = labelString.indexOf(NAMESPACE_DELIMITER);
            userName = labelString.substring(1, index);
            labelName = labelString.substring(index + 1);
            prefix = PERSONAL_LABEL_PREFIX;
        } else if (labelString.toLowerCase().startsWith(TEAM_LABEL_PREFIX)) {
            labelName = labelString.substring(TEAM_LABEL_PREFIX.length());
            prefix = TEAM_LABEL_PREFIX;
        } else {
            userName = null;
            labelName = labelString;
        }
        if (!LabelParser.isValidLabelName(labelName)) {
            return null;
        }
        return new ParsedLabelName(labelName, userName, prefix);
    }

    public static String getInvalidCharactersAsString() {
        String result = "";
        for (int i = 0; i < INVALID_CHARACTERS.length; ++i) {
            char invalidCharacter = INVALID_CHARACTERS[i];
            result = result + invalidCharacter + (i != INVALID_CHARACTERS.length - 1 ? ", " : "");
        }
        return result;
    }

    public static ParsedLabelName create(String labelName, String userName) {
        if (!LabelParser.isValidLabelName(labelName)) {
            return null;
        }
        return new ParsedLabelName(labelName, userName);
    }

    public static ParsedLabelName create(Label label) {
        return new ParsedLabelName(label.getName(), label.getOwner());
    }

    public static String render(Label label) {
        return LabelParser.render(LabelParser.create(label));
    }

    public static String render(ParsedLabelName parsedLabelName) {
        StringBuffer output = new StringBuffer();
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user != null && parsedLabelName.getOwner() != null && user.getName().equals(parsedLabelName.getOwner())) {
            output.append(PERSONAL_LABEL_PREFIX);
        } else if (parsedLabelName.getOwner() != null) {
            output.append(USER_LABEL_PREFIX);
            output.append(parsedLabelName.getOwner());
            output.append(NAMESPACE_DELIMITER);
        } else if (TextUtils.stringSet((String)parsedLabelName.getPrefix())) {
            output.append(parsedLabelName.getPrefix());
            output.append(NAMESPACE_DELIMITER);
        }
        output.append(parsedLabelName.getName());
        return output.toString();
    }

    static {
        Arrays.sort(INVALID_CHARACTERS);
    }
}

